<?php

namespace ElementPress\Modules\Sticky_Header;


define('Sticky_Header_File', __FILE__);
define('Sticky_Header_Path', plugin_dir_path(Sticky_Header_File));
define('Sticky_Header_Url', plugins_url('/', Sticky_Header_File));
define('Sticky_Header_Assets_Url', Sticky_Header_Url . 'assets/');
define('Sticky_Header_Modules_Url', Sticky_Header_Url . 'modules/');

use Elementor;
use Elementor\Utils;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Init
{


    private static $_instance;
    private $_modules_manager;

    public static function elementor()
    {
        return \Elementor\Plugin::$instance;
    }


    public static function instance()
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    private function _includes()
    {
        require Sticky_Header_Path . 'includes/modules-manager.php';

    }

    public function autoload($class)
    {
        if (0 !== strpos($class, __NAMESPACE__)) {
            return;
        }

        $filename = strtolower(
            preg_replace(
                ['/^' . __NAMESPACE__ . '\\\/', '/([a-z])([A-Z])/', '/_/', '/\\\/'],
                ['', '$1-$2', '-', DIRECTORY_SEPARATOR],
                $class
            )
        );
        $filename = Sticky_Header_Path . $filename . '.php';

        if (is_readable($filename)) {
            include($filename);
        }
    }

    public function enqueue_styles()
    {
        $suffix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';
        $direction_suffix = is_rtl() ? '-rtl' : '';
    }

    public function enqueue_frontend_scripts()
    {
        $suffix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';
    }

    public function enqueue_editor_scripts()
    {
        $suffix = Utils::is_script_debug() ? '' : '.min';
    }

    public function register_frontend_scripts()
    {
        $suffix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

    }

    public function enqueue_editor_styles()
    {
        $suffix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';
    }


    private function setup_hooks()
    {
        $this->_modules_manager = new Manager();

        $elementor = Elementor\Plugin::$instance;

        // Add element category in panel
        $elementor->elements_manager->add_category(
            'epress-sticky-header',
            [
                'title' => __('ElementPress Sticky Header', 'elementpress'),
                'icon' => 'font',
            ],
            1
        );

        do_action('elementor_controls/init');
    }


    public function __construct()
    {
        spl_autoload_register([$this, 'autoload']);

        $this->_includes();

        $this->setup_hooks();

    }
}



