<?php

namespace ElementPress\Modules\Epress_Forms\Widgets;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Core\Schemes\Typography as Scheme_Typography;
use Elementor\Plugins;

if (!defined('ABSPATH')) exit;

class Forms extends Widget_Base
{
    public function get_name()
    {
        return 'epress-forms';
    }

    public function get_title()
    {
        return __('Epress Forms', 'elementpress');
    }

    public function get_icon()
    {
        return 'eicon-form-horizontal';
    }

    public function get_keywords()
    {
        return ['form', 'forms', 'field', 'button'];
    }

    public function get_categories()
    {
        //get category from input-handler.php file
        return ['additional-addons'];
    }

    protected function register_controls()
    {
        //content section named input
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Form field', 'elementpress'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = $this->register_repeater();

        //To Email Address control
        $this->add_control(
            'reciver_email',
            [

                'label' => __('To Email', 'elementpress'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __(get_option('admin_email'), 'elementpress'),
                'placeholder' => __('abc@abc.com', 'elementpress'),
            ]
        );
        //Sender Email Address control
        $this->add_control(
            'sender_email',
            [

                'label' => __('From Email', 'elementpress'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __(get_option('admin_email'), 'elementpress'),
                'placeholder' => __('abc@abc.com', 'elementpress'),
            ]
        );
        //Email Subject control
        $this->add_control(
            'email_subject',
            [

                'label' => __('Email Subject', 'elementpress'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Contact Form Query', 'elementpress'),
                'placeholder' => __('Enter Email Subject', 'elementpress'),
            ]
        );
        //$repeater = new \Elementor\Repeater();
        $this->add_control(
            'input_list',
            [
                'label' => __('fields', 'elementpress'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'add_input' => __('Select field', 'elementpress'),
                        'input_text_color' => __('Select field Color', 'elementpress'),
                        'input_css_class' => __('Custom Class', 'elementpress'),
                    ],

                ],
                'title_field' => '{{{ add_input }}}',
            ]
        );

        $this->add_control(
            'input_align',
            [
                'label' => __('Label Alignment', 'elementpress'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'elementpress'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'elementpress'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'elementpress'),
                        'icon' => 'fa fa-align-right',

                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .outer' => 'text-align: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );


        $this->end_controls_section();
        //start style section
        $this->start_controls_section(
            'lebel_section_style',
            [
                'label' => __('Label Style', 'additional-addons'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs('input_name_style_tabs');

        // Additional Information Heading Normal Style

        $this->start_controls_tab(
            'input_name_normal',
            [
                'label' => __('Normal', 'masterelements'),
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            array(
                'name' => 'input_name_typography',
                'label' => __('Typography', 'masterelements'),
                'selector' => '{{WRAPPER}} label.me-label',
            )
        );

        $this->add_control(
            'input_name_color',
            [
                'label' => __('Color', 'masterelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} label.me-label' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'input_name_bg_color',
            [
                'label' => __('Background Color', 'masterelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} label.me-label' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'input_name_border',
                'label' => __('Border', 'masterelements'),
                'selector' => '{{WRAPPER}} label.me-label',
            ]
        );

        $this->add_responsive_control(
            'input_name_border_radius',
            [
                'label' => __('Border Radius', 'masterelements'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} label.me-label' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'input_name_padding',
            [
                'label' => __('Padding', 'masterelements'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} label.me-label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'input_name_margin',
            [
                'label' => __('Margin', 'masterelements'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} label.me-label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'me_form_input_box_hover',
            [
                'label' => __('Hover', 'masterelements'),
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            array(
                'name' => 'input_name_typography_hover',
                'label' => __('Typography', 'masterelements'),
                'selector' => '{{WRAPPER}} label.me-label:hover',
            )
        );

        $this->add_control(
            'input_name_color_hover',
            [
                'label' => __('Color', 'masterelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} label.me-label:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'input_name_bg_color_hover',
            [
                'label' => __('Background Color', 'masterelements'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} label.me-label:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'input_name_border_hover',
                'label' => __('Border', 'masterelements'),
                'selector' => '{{WRAPPER}} label.me-label:hover',
            ]
        );

        $this->add_responsive_control(
            'input_name_border_radius_hover',
            [
                'label' => __('Border Radius', 'masterelements'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} label.me-label:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => __('Button Style', 'additional-addons'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        //button title control
        $this->add_control(
            'input_name',
            [

                'label' => __('Button Title ', 'elementpress'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Submit!', 'elementpress'),
                'placeholder' => __('Send', 'elementpress'),
            ]
        );
        $this->start_controls_tabs(
            'button_tabs'
        );
        //Button Normal Style
        $this->start_controls_tab(
            'button_normal',
            [
                'label' => esc_html__('Normal', 'elementpress'),
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'label' => __('Button Typography', 'elementpress'),
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .epress-submit-btn',
            ]

        );
        //width slider control
        $this->add_responsive_control(
            'width',
            [
                'label' => __('Width', 'elementpress'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'devices' => ['desktop','tablet','mobile'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .epress-submit-btn' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        //width Tablet slider control
//        $this->add_responsive_control(
//            'width_tablet',
//            [
//                'label' => __('Width', 'elementpress'),
//                'type' => Controls_Manager::SLIDER,
//                'size_units' => ['px', '%'],
//                'devices' => ['tablet', 'mobile'],
//                'range' => [
//                    'px' => [
//                        'min' => 1,
//                        'max' => 500,
//                        'step' => 1,
//                    ],
//                    '%' => [
//                        'min' => 1,
//                        'max' => 100,
//                    ],
//                ],
//                'default' => [
//                    'unit' => '%',
//                    'size' => 50,
//                ],
//                'selectors' => [
//                    '{{WRAPPER}} .epress-submit-btn' => 'width: {{SIZE}}{{UNIT}};',
//                ],
//            ]
//        );
        //Height slider control for button on Desktop
        $this->add_responsive_control(
            'height',
            [
                'label' => __('Height', 'elementpress'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'devices' => ['desktop','tablet','mobile'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .epress-submit-btn' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        //Height slider control for button on Tablet/Mobile
//        $this->add_responsive_control(
//            'height',
//            [
//                'label' => __('Height', 'elementpress'),
//                'type' => Controls_Manager::SLIDER,
//                'size_units' => ['px', '%'],
//                'devices' => ['tablet', 'mobile'],
//                'range' => [
//                    'px' => [
//                        'min' => 1,
//                        'max' => 500,
//                        'step' => 1,
//                    ],
//                    '%' => [
//                        'min' => 0,
//                        'max' => 100,
//                    ],
//                ],
//                'default' => [
//                    'unit' => 'px',
//                    'size' => 50,
//                ],
//                'selectors' => [
//                    '{{WRAPPER}} .epress-submit-btn' => 'height: {{SIZE}}{{UNIT}};',
//                ],
//            ]
//        );
        //margin control for input
        $this->add_responsive_control(
            'margin',
            [
                'label' => __('Margin', 'elementpress'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'devices' => ['desktop','tablet','mobile'],
                'selectors' => [
                    '{{WRAPPER}} .epress-submit-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        //margin control for input
//        $this->add_responsive_control(
//            'margin_tablet',
//            [
//                'label' => __('Margin', 'elementpress'),
//                'type' => Controls_Manager::DIMENSIONS,
//                'size_units' => ['px', '%', 'em'],
//                'devices' => ['tablet', 'mobile'],
//                'selectors' => [
//                    '{{WRAPPER}} .epress-submit-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
//                ],
//            ]
//        );
        //padding control for input
        $this->add_responsive_control(
            'padding',
            [
                'label' => __('Padding', 'elementpress'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'devices' => ['desktop','tablet','mobile'],
                'selectors' => [
                    '{{WRAPPER}} .epress-submit-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        //padding control for button on tablet Mobile
//        $this->add_responsive_control(
//            'padding',
//            [
//                'label' => __('Padding', 'elementpress'),
//                'type' => Controls_Manager::DIMENSIONS,
//                'size_units' => ['px', '%', 'em'],
//                'devices' => ['tablet', 'mobile'],
//                'selectors' => [
//                    '{{WRAPPER}} .epress-submit-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
//                ],
//            ]
//        );

        //border
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __('Border', 'elementpress'),
                'selector' => '{{WRAPPER}} .epress-submit-btn',
            ]
        );
        //border radius control
        $this->add_control(
            'border_radius',
            [
                'label' => __('Border Radius', 'elementpress'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .epress-submit-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        //text shadow control
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'text_shadow',
                'label' => __('Text Shadow', 'elementpress'),
                'selector' => '{{WRAPPER}} .epress-submit-btn',
            ]
        );
        //box shadow control
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => __('Box Shadow', 'elementpress'),
                'selector' => '{{WRAPPER}} .epress-submit-btn',
            ]
        );
        //box align control for button on desktop
        $this->add_responsive_control(
            'button_align',
            [
                'label' => __('Alignment', 'elementpress'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'elementpress'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'elementpress'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'elementpress'),
                        'icon' => 'fa fa-align-right',

                    ],
                ],
                'default' => 'left',
                'devices' => ['desktop','tablet','mobile'],
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        //box align control for button on  tablet/Mobile
//        $this->add_responsive_control(
//            'button_align',
//            [
//                'label' => __('Alignment', 'elementpress'),
//                'type' => Controls_Manager::CHOOSE,
//                'devices' => ['tablet', 'mobile'],
//                'options' => [
//                    'left' => [
//                        'title' => __('Left', 'elementpress'),
//                        'icon' => 'fa fa-align-left',
//                    ],
//                    'center' => [
//                        'title' => __('Center', 'elementpress'),
//                        'icon' => 'fa fa-align-center',
//                    ],
//                    'right' => [
//                        'title' => __('Right', 'elementpress'),
//                        'icon' => 'fa fa-align-right',
//
//                    ],
//                ],
//                'default' => 'left',
//                'selectors' => [
//                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
//                ],
//                'separator' => 'before',
//            ]
//        );
        //color picker control for input text color
        $this->add_control(
            'button_color',
            [
                'label' => esc_html__('Color', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .epress-submit-btn' => 'color: {{VALUE}};',
                ],
            ]
        );
        //color picker control for background color
        $this->add_control(
            'button_backgroundcolor',
            [
                'label' => esc_html__('Background Color', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .epress-submit-btn' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'position_for_btn',
            [
                'label' => __('Button Position', 'elementpress'),
                'label_block' => true,
                'type' => Controls_Manager::SELECT,
                'multiple' => true,
                'default' => __('None', 'elementpress'),
                'options' => [
                    'none' => __('None', 'elementpress'),
                    'relative' => __('Relative', 'elementpress'),
                    'absolute' => __('Absolute', 'elementpress'),
                    'fixed' => __('Fixed', 'elementpress'),

                ],
                //'separator' => 'before',
            ]
        );

        //top slider control
        $this->add_control(
            'position_for_btn_top',
            [
                'label' => __('TOP', 'elementpress'),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}}  .epress-submit-btn' => 'top: {{VALUE}}px;',
                ],
            ]
        );


        $this->add_control(
            'position_for_btn_right',
            [
                'label' => __('RIGHT', 'elementpress'),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}}  .epress-submit-btn' => 'right: {{VALUE}}px;',
                ],
            ]
        );


        $this->add_control(
            'position_for_btn_left',
            [
                'label' => __('LEFT', 'elementpress'),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}}  .epress-submit-btn' => 'left: {{VALUE}}px;',
                ],
            ]
        );


        $this->add_control(
            'position_for_btn_bottom',
            [
                'label' => __('BOTTOM', 'elementpress'),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}}  .epress-submit-btn' => 'bottom: {{VALUE}}px;',
                ],
            ]
        );


        $this->end_controls_tab();

        //Button Hover Style
        $this->start_controls_tab(
            'button_hover',
            [
                'label' => esc_html__('Hover', 'elementpress'),
            ]
        );
        $this->add_control(
            'button_color_hover',
            [
                'label' => esc_html__('Color', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .epress-submit-btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        //color picker control for background color
        $this->add_control(
            'button_backgroundcolor_hover',
            [
                'label' => esc_html__('Background Color', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .epress-submit-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        //border
        $this->add_control(
            'border_hover',
            [
                'label' => __('Border Color', 'elementor-pro'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .epress-submit-btn:hover' => 'border-color: {{VALUE}};',
                ]
            ]
        );
        //border radius control
        $this->add_control(
            'border_radius_hover',
            [
                'label' => __('Border Radius', 'elementpress'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .epress-submit-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        //Button Hover Style End

        $this->end_controls_tab();
        //Button Style tab Close
        $this->end_controls_section();
    }


    //front end rendering
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        //secho $settings;
        ?>
        <form method="post" action="" class="epress-contact-form">
            <input type="hidden" name="form_id" value="<?php echo $this->get_id(); ?>"/>


            <?php
            $width = 100;

            if (count($settings['input_list']) != 0 && ($settings['input_list'][0]['add_input'] != 'Select field' && $settings['input_list'][0]['add_input'] != 'Select field Type')) {
                if(isset($settingsp['input_list_2'])){
                    if (count($settings['input_list_2']) != 0 && ($settings['input_list_2'][0]['add_input'] != 'Select field' && $settings['input_list_2'][0]['add_input'] != 'Select field Type')) {
                        $width = 50;
                    }
                }
            }

            if (count($settings['input_list']) != 0) {
                if ($settings['input_list'][0]['add_input'] != 'Select field' && $settings['input_list'][0]['add_input'] != 'Select field Type') {
                    foreach ($settings['input_list'] as $item) {
                        $required = ($item['required'] ? ' required ' : '');

                        $listinput = $item['add_input'];

                        $this->get_template_fields($listinput, $item, $required);
                    }
                }
            }

            ?>
            <div class="epress-button-outer"><input
                        class="epress-submit-btn epress-<?= $settings['position_for_btn']; ?>" type="submit"
                        value="<?= $settings['input_name'] ?>"></div>
        </form>
        <?php

    }

    public static function get_current_post_id()
    {
        if (isset(Plugin::elementor()->documents)) {
            return Plugin::elementor()->documents->get_current()->get_main_id();
        }

        return get_the_ID();
    }

    protected function content_template()
    {
    }

    public function get_template_fields($listinput, $item, $required)
    {
        if ($listinput == 'text') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-text"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>

                <input name="<?= $item['input_name']; ?>" <?= $required; ?>
                       class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>" type="text"
                       placeholder="<?= $item['input_placeholder'] ?>">
            </div>

        <?php }
        if ($listinput == 'select') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-text"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <select name="<?= $item['input_name']; ?>"
                        <?= $required; ?>class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>" <?= ($item['allow_multiple'] ? ' multiple' : ''); ?>>
                    <?php
                    $field_options = $item['field_options'];
                    $options = explode(PHP_EOL, $field_options);
                    foreach ($options as $option) {
                        $opt = explode('|', $option);
                        echo '<option value="' . $opt[0] . '">' . $opt[1] . '</option>';
                    }

                    ?>

                </select>

            </div>

        <?php }
        if ($listinput == 'email') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-<?= $listinput; ?>"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input name="<?= $item['input_name']; ?>"
                       <?= $required; ?>class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>"
                       type="email" placeholder="<?= $item['input_placeholder'] ?>">
            </div>

        <?php }
        if ($listinput == 'tel') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-<?= $listinput; ?>"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input name="<?= $item['input_name']; ?>"
                       <?= $required; ?>class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>"
                       type="tel" placeholder="<?= $item['input_placeholder'] ?>">
            </div>

        <?php }
        if ($listinput == 'textarea') { ?>

            <div class="<?= $item['input_css_class'] ?> outer outer-textarea elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <textarea <?= $required; ?> class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>"
                                            placeholder="<?= $item['input_placeholder']; ?>"></textarea>
            </div>
            <?php
        }
        if ($listinput == 'checkbox') {
            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-checkbox"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input <?= $required; ?>class="elementor-repeater-files-<?php echo esc_attr($item['_id']); ?>"
                       value="click me" type="checkbox"></div>

            <?php
        }
        if ($listinput == 'color') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-color"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input <?= $required; ?> name="<?= $item['input_name']; ?>"
                                         class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>"
                                         type="color">
            </div>
            <?php
        }
        if ($listinput == 'date') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-<?= $listinput; ?>"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input <?= $required; ?> name="<?= $item['input_name']; ?>"
                                         class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>"
                                         type="date">
            </div>
            <?php
        }
        if ($listinput == 'file') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-<?= $listinput; ?>"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input <?= $required; ?> name="<?= $item['input_name']; ?>"
                                         class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>"
                                         type="file">
            </div>

        <?php }
        if ($listinput == 'hidden') {

            ?>
            <div class="<?= $item['input_css_class'] ?> outer outer-<?= $listinput; ?>"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input <?= $required; ?> name="<?= $item['input_name']; ?>"
                                         class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?>"
                                         type="hidden">
            </div>

        <?php }
        if ($listinput == 'number') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-<?= $listinput; ?>"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input name="<?= $item['input_name']; ?>"
                       class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>"
                       type="number" <?= $required; ?> placeholder="<?= $item['input_placeholder'] ?>">
            </div>

        <?php }
        if ($listinput == 'password') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-<?= $listinput; ?>"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input name="<?= $item['input_name']; ?>"
                       class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>"
                       type="password" <?= $required; ?> placeholder="<?= $item['input_placeholder'] ?>">
            </div>

        <?php }
        if ($listinput == 'radio') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-<?= $listinput; ?>"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input name="<?= $item['input_name']; ?>"
                       class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>"
                       type="radio" <?= $required; ?>>
            </div>

        <?php }
        if ($listinput == 'reset') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-<?= $listinput; ?>"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input <?= $required; ?> name="<?= $item['input_name']; ?>"
                                         class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>"
                                         type="reset">
            </div>

        <?php }
        if ($listinput == 'search') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-<?= $listinput; ?>"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input <?= $required; ?> name="<?= $item['input_name']; ?>"
                                         class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>"
                                         type="search" placeholder="<?= $item['input_placeholder'] ?>">
            </div>

        <?php }
        if ($listinput == 'url') {

            ?>
            <div class="elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> <?= $item['input_css_class'] ?> outer outer-<?= $listinput; ?>"
                 style="float: left;">
                <?php $this->checkLabel($item); ?>
                <input <?= $required; ?> name="<?= $item['input_name']; ?>"
                                         class="elementor-repeater-field-<?php echo esc_attr($item['_id']); ?>"
                                         type="url" placeholder="<?= $item['input_placeholder'] ?>">
            </div>

        <?php }
    }

    public function register_repeater()
    {
        //repeater
        $repeater = new \Elementor\Repeater();
        //which input you want to include select box control
        $repeater->add_control(
            'add_input',
            [
                'label' => __('Add field', 'elementpress'),
                'label_block' => true,
                'type' => Controls_Manager::SELECT,
                'multiple' => false,
                'default' => __('Select field Type', 'elementpress'),
                'options' => [
                    'text' => __('Text', 'elementpress'),
                    'tel' => __('Telephone', 'elementpress'),
                    'email' => __('Email', 'elementpress'),
                    'textarea' => __('Textarea', 'elementpress'),
                    'select' => __('Select', 'elementpress'),
                    'checkbox' => __('Checkbox', 'elementpress'),
                    'file' => __('File', 'elementpress'),
                    'date' => __('Date', 'elementpress'),
                    'number' => __('Number', 'elementpress'),
                    'password' => __('Password', 'elementpress'),
                    'radio' => __('Radio', 'elementpress'),
                    'url' => __('URL', 'elementpress'),
                    'hidden' => __('Hidden', 'elementpress'),
                    'reset' => __('Reset Button', 'elementpress'),
                ],
                'separator' => 'before',
            ]
        );

        //input Name control
        $repeater->add_control(
            'input_name',
            [

                'label' => __('Label & Field Name', 'elementpress'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('', 'elementpress'),
                'placeholder' => __('Enter Your field name', 'elementpress'),
            ]
        );

        //input placeholder control
        $repeater->add_control(
            'input_placeholder',
            [

                'label' => __('Placeholder ', 'elementpress'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'add_input',
                            'operator' => '!==',
                            'value' => 'select',
                        ],
                    ],
                ],
                'default' => __('Placeholder', 'elementpress'),
                'placeholder' => __('Placeholder', 'elementpress'),
            ]
        );

        $repeater->add_control(
            'input_box_label',
            [
                'label' => __('Input Box Label', 'elementpress'),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'true',
                'default' => '',
            ]
        );

        $repeater->add_control(
            'required',
            [
                'label' => __('Required', 'elementpress'),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'true',
                'default' => '',
            ]
        );

        $repeater->add_control(
            'field_options',
            [
                'label' => __('Options', 'elementpress'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '',
                'description' => __('Enter each option in a separate line. To differentiate between label and value, separate them with a pipe char ("|"). For example: First Name|f_name', 'elementor-pro'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'add_input',
                            'value' => 'select',
                        ],
                    ],
                ],
            ]
        );

        $repeater->add_control(
            'allow_multiple',
            [
                'label' => __('Multiple Selection', 'elementpress'),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'true',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'add_input',
                            'value' => 'select',
                        ],
                    ],
                ],
            ]
        );
        //input select box control for inline styling
        $repeater->add_control(
            'display',
            [
                'label' => __('Display', 'elementpress'),
                'label_block' => true,
                'type' => Controls_Manager::SELECT,
                'multiple' => true,
                'default' => 'inline-block',
                'options' => [
                    'inline-flex' => __('Inline flex', 'elementpress'),
                    'inline-block' => __('Inline Block', 'elementpress'),
                    'inline' => __('Inline', 'elementpress'),

                ],
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}},{{WRAPPER}} {{CURRENT_ITEM}}' => 'display: {{VALUE}};',
                ],
            ]
        );
        //width slider control
        $repeater->add_responsive_control(
            'width',
            [
                'label' => __('Width', 'elementpress'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'devices' => ['desktop','tablet','mobile'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        //width Mobile slider control
//        $repeater->add_responsive_control(
//            'width_table',
//            [
//                'label' => __('Width', 'elementpress'),
//                'type' => Controls_Manager::SLIDER,
//                'size_units' => ['px', '%'],
//                'devices' => ['tablet', 'mobile'],
//                'range' => [
//                    'px' => [
//                        'min' => 0,
//                        'max' => 1000,
//                        'step' => 5,
//                    ],
//                    '%' => [
//                        'min' => 0,
//                        'max' => 100,
//                    ],
//                ],
//                'default' => [
//                    'unit' => '%',
//                    'size' => 50,
//                ],
//                'selectors' => [
//                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'width: {{SIZE}}{{UNIT}};',
//                ],
//            ]
//        );

        //Height slider control
        $repeater->add_responsive_control(
            'height',
            [
                'label' => __('Height', 'elementpress'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'desktop_default' => [
                    'size' => 30,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'size' => 20,
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'size' => 10,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} input,{{WRAPPER}} {{CURRENT_ITEM}} textarea,{{WRAPPER}} {{CURRENT_ITEM}} select' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        //margin control for input
        $repeater->add_responsive_control(
            'margin',
            [
                'label' => __('Margin', 'elementpress'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'devices' => ['desktop','tablet','mobile'],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        //margin control for input
//        $repeater->add_responsive_control(
//            'margin_tablet',
//            [
//                'label' => __('Margin', 'elementpress'),
//                'type' => Controls_Manager::DIMENSIONS,
//                'size_units' => ['px', '%', 'em'],
//                'devices' => ['tablet', 'mobile'],
//                'selectors' => [
//                    '{{WRAPPER}} {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
//                ],
//            ]
//        );
        //padding control for input
        $repeater->add_control(
            'padding',
            [
                'label' => __('Padding', 'elementpress'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} input,{{WRAPPER}} {{CURRENT_ITEM}} textarea,{{WRAPPER}} {{CURRENT_ITEM}} select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        //border
        $repeater->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __('Border', 'elementpress'),
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} input,{{WRAPPER}} {{CURRENT_ITEM}} textarea,{{WRAPPER}} {{CURRENT_ITEM}} select',
            ]
        );
        //border radius control
        $repeater->add_control(
            'border_radius',
            [
                'label' => __('Border Radius', 'elementpress'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} input,{{WRAPPER}} {{CURRENT_ITEM}} textarea,{{WRAPPER}} {{CURRENT_ITEM}} select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $repeater->start_controls_tabs(
            'intput_tabs'
        );
        $repeater->start_controls_tab(
            'input_normal',
            [
                'label' => esc_html__('Normal', 'elementpress'),
            ]
        );
        //color picker control for input text color
        $repeater->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'input_typography',
                'label' => __('Input Typography', 'elementpress'),
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                'devices' => ['desktop','tablet','mobile'],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} input,{{WRAPPER}} {{CURRENT_ITEM}} textarea,{{WRAPPER}} {{CURRENT_ITEM}} select',
            ]
        );
        //color picker control for input text color
//        $repeater->add_group_control(
//            Group_Control_Typography::get_type(),
//            [
//                'name' => 'input_typography_tablet',
//                'label' => __('Input Typography', 'elementpress'),
//                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
//                'devices' => ['tablet', 'mobile'],
//                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} input,{{WRAPPER}} {{CURRENT_ITEM}} textarea,{{WRAPPER}} {{CURRENT_ITEM}} select',
//            ]
//        );
        //placeholder typography control for input
        $repeater->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'placeholder_typography',
                'label' => __('Placeholder Typography', 'elementpress'),
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'add_input',
                            'operator' => '!==',
                            'value' => 'select',
                        ],
                    ],
                ],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} input::-webkit-input-placeholder,{{WRAPPER}} {{CURRENT_ITEM}} textarea::-webkit-input-placeholder',
            ]
        );
        //text shadow control
        $repeater->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'text_shadow',
                'label' => __('Text Shadow', 'elementpress'),
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} input,{{WRAPPER}} {{CURRENT_ITEM}} textarea,{{WRAPPER}} {{CURRENT_ITEM}} select',
            ]
        );
        //box shadow control
        $repeater->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => __('Box Shadow', 'elementpress'),
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} input,{{WRAPPER}} {{CURRENT_ITEM}} textarea,{{WRAPPER}} {{CURRENT_ITEM}} select',
            ]
        );
        //color picker control for input text color
        $repeater->add_responsive_control(
            'input_text_color',
            [
                'label' => esc_html__('Color', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} input,{{WRAPPER}} {{CURRENT_ITEM}} textarea,{{WRAPPER}} {{CURRENT_ITEM}} select' => 'color: {{VALUE}};',
                ],
            ]
        );
        //color picker control for background color
        $repeater->add_responsive_control(
            'input_text_backgroundcolor',
            [
                'label' => esc_html__('Background Color', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} input,{{WRAPPER}} {{CURRENT_ITEM}} textarea,{{WRAPPER}} {{CURRENT_ITEM}} select' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        //color picker control for placeholder color
        $repeater->add_responsive_control(
            'input_text_placeholder',
            [
                'label' => esc_html__('Placeholder Color', 'elementpress'),
                'type' => Controls_Manager::COLOR,
                'default' => '#6115d0',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'add_input',
                            'operator' => '!==',
                            'value' => 'select',
                        ],
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} input::-webkit-input-placeholder,{{WRAPPER}} {{CURRENT_ITEM}} textarea::-webkit-input-placeholder ' => 'color: {{VALUE}};',
                ],
            ]
        );
        //your css class control
        $repeater->add_control(
            'input_css_class',
            [
                'label' => esc_html__('Custom Class', 'elementpress'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __('Your css class', 'elementpress'),

            ]
        );
        $repeater->end_controls_tab();

        return $repeater;
    }

    public function checkLabel($item)
    {
        if ($item['input_box_label'] == 'true') {
            echo '<label class="me-label">' . $item['input_name'] . '</label>';
        }
    }
    /* public function __construct() {
       // add_action( 'wp_ajax_submit_form', [ $this, 'submit_form' ] );
       // add_action( 'wp_ajax_nopriv_submit_form', [ $this, 'submit_form' ] );
    }*/
}
