<?php


$modules_all = \ElementPress::default_modules();


$modules_active = $this->utils->get_option('module_list', $modules_all);


$modules_free = \ElementPress::default_modules('free');


?>





<div class="epress-admin-header">


    <h2 class="epress-admin-header-title"><?php esc_html_e('Active Module List', 'elementpress'); ?></h2>


</div>


<div class="epress-admin-fields-container">


    <span class="epress-admin-fields-container-description"><?php esc_html_e('You can disable the modules you are not using on your site. That will disable all associated assets of those modules to improve your site loading.', 'elementpress'); ?></span>


    <div class="epress-admin-fields-container-fieldset">


        <div class="attr-hidden" id="elementpress-template-admin-menu">


            <ul><li><a href="edit.php?post_type=elementpresstemplate"><?php esc_html_e('My Templates', 'elementpress'); ?></a></li></ul>


        </div>


        <div class="attr-row">


        <?php foreach($modules_all as $module): ?>


            <div class="attr-col-md-6 attr-col-lg-4">


            <?php


                $this->utils->input([


                    'type' => 'switch',


                    'name' => 'module_list[]',


                    'value' => $module,


                    'class' => ((in_array($module, $modules_free)) ? 'epress-content-type-free' : 'epress-content-type-pro'),


                    'label' => ucwords(str_replace('-', ' ', $module)),


                    'options' => [


                        'checked' => ((in_array($module, $modules_active)) ? true : false),


                    ]


                ]);


            ?>


            </div>


            <?php endforeach; ?>


        </div>


    </div>


</div>