<?php 
namespace ElementPress\Admin;
use ElementPress\Admin\Classes\Utils;

defined( 'ABSPATH' ) || exit;

class Attr{

    public static $instance = null;
    public $utils;

    public static function get_url(){
        return \ElementPress::admin_url() ;
    }
    public static function get_dir(){
        return \ElementPress::admin_dir() ;
    }

    public static function key(){
        return 'elementpress';
    }

    public function __construct() {
        $this->utils = Classes\Utils::instance();
        // new Classes\Ajax;

        // register admin menus
        add_action('admin_menu', [$this, 'create_menu']);
        add_action('admin_menu', [$this, 'templates_submenu'], 999);
        add_action('admin_menu', [$this, 'settings_submenu'], 999);

        // register js/ css
       // add_action( 'admin_enqueue_scripts', [$this, 'enqueue_scripts'] );
        
    }

    public function create_menu(){
       
        // dashboard, main menu
        add_menu_page(
            esc_html__( 'ElementPress', 'elementpress' ),
            esc_html__( 'ElementPress', 'elementpress' ),
            'manage_options',
            'elementpress',
            [$this, 'dashboard'],
            self::get_url() . 'assets/images/elementor-logo.png',
            2
        );

    }

    public function templates_submenu(){
//        add_submenu_page( self::key(), esc_html__( 'Templates', 'elementpress' ), esc_html__( 'Templates', 'elementpress' ), 'manage_options', 'templates', [$this, 'templates'], 11);
    }
    public function settings_submenu(){
//        add_submenu_page( self::key(), esc_html__( 'Settings', 'elementpress' ), esc_html__( 'Settings', 'elementpress' ), 'manage_options', 'settings', [$this, 'settings_page'], 11);
    }

    function dashboard() //Dashboard Screen after clicked on ElementPress option
    {   		
        include_once self::get_dir(). 'pages/dashboard.php';
    }

    function templates() //Templates Screen after clicked on Templates option
    {	
        include_once self::get_dir(). 'pages/templates.php';
    }
    function settings_page() //Settings Screen after clicked on Settings option
    {	
        include_once self::get_dir(). 'pages/settings.php';
    }

    public static function instance() {
        if ( is_null( self::$instance ) ) {

            // Fire the class instance
            self::$instance = new self();
        }
        return self::$instance;
    }
}