<?php
namespace Elementor;
use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography as Scheme_Typography;
Use Elementor\Core\Schemes\Color as Scheme_Color;

if ( ! defined( 'ABSPATH' ) ) exit;


class Elementpress_Widget_Team extends Widget_Base {


    public $base;
    
    public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);



        wp_register_style( 'team-css',  \ElementPress::widgets_url() . '/team/team.css', false, \ElementPress::version );
        wp_register_script( 'team-js', \ElementPress::widgets_url() .'/team/all.min.js', array( 'jquery' ), \ElementPress::version, true );
      //  wp_register_script( 'team-elementor-js', \ElementPress::widgets_url() .'/team/elementor_min.js', array( 'jquery' ), \ElementPress::version, true );


     }
     public function get_script_depends() {
		
        return [ 'team-js' ];
     }

  
	  public function get_style_depends() {
		 
		 return [ 'team-css' ];
	  }

    public function get_name() {
        return 'elementpress-team';
    }

    public function get_title() {
        return esc_html__( 'Team', 'elementpress' );
    }

    public function get_icon() {
        return 'eicon-posts-grid epress-widget-icon ';
    }

    public function get_categories() {
        return [ 'additional-addons' ];
    }


    protected function register_controls() {

        // Team Content
        $this->start_controls_section(
            'epress_team_content', [
                'label' => esc_html__( 'Team Member Content', 'elementpress' ),
            ]
        );

        $this->add_control(
            'epress_team_style',
            [
                'label' =>esc_html__( 'Style', 'elementpress' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default' => esc_html__( 'Default', 'elementpress' ),
                    'overlay' => esc_html__( 'Overlay', 'elementpress' ),
                    'centered_style' => esc_html__( 'Centered ', 'elementpress' ),
                    'hover_info' => esc_html__( 'Hover on social', 'elementpress' ),
                    'overlay_details' => esc_html__( 'Overlay with details', 'elementpress' ),
                    'centered_style_details' => esc_html__( 'Centered with details ', 'elementpress' ),
                    'long_height_hover' => esc_html__( 'Long height with hover ', 'elementpress' ),
                    'long_height_details' => esc_html__( 'Long height with details ', 'elementpress' ),
                    'long_height_details_hover' => esc_html__( 'Long height with details & hover', 'elementpress' ),
                    'overlay_circle' => esc_html__( 'Overlay with circle shape', 'elementpress' ),
                    'overlay_circle_hover' => esc_html__( 'Overlay with circle shape & hover', 'elementpress' ),
                ],
            ]
        );

        $this->add_control(
            'epress_team_image',
            [
                'label' => esc_html__( 'Choose Member Image', 'elementpress' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'epress_team_thumbnail',
                'default' => 'large',
            ]
        );

        $this->add_control(
            'epress_team_name',
            [
                'label' => esc_html__( 'Member Name', 'elementpress' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Jane Doe', 'elementpress' ),
                'placeholder' => esc_html__( 'Member Name', 'elementpress' ),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'epress_team_position',
            [
                'label' => esc_html__( 'Member Position', 'elementpress' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Designer', 'elementpress' ),
                'placeholder' => esc_html__( 'Member Position', 'elementpress' ),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
			'epress_team_margin',
			[
				'label' => __( 'Margin', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .profile-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


        $this->add_control(
			'epress_team_show_short_description',
			[
				'label' => esc_html__( 'Show Description', 'elementpress' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'elementpress' ),
				'label_off' => esc_html__( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        $this->add_control(
            'epress_team_short_description',
            [
                'label' => esc_html__( 'About Member', 'elementpress' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'A small river named Duden flows by their place and supplies it with the necessary', 'elementpress' ),
                'placeholder' => esc_html__( 'About Member', 'elementpress' ),
                'condition' => [
                    'epress_team_show_short_description' => 'yes'
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();


        // Team Social section

	   $this->start_controls_section(
            'epress_team_section_social', [
                'label' => esc_html__( 'Social  Profiles', 'elementpress' ),
            ]
        );

        $this->add_control(
            'epress_team_socail_enable',
            [
                'label' => esc_html__( 'Display Social Profiles?', 'elements-test' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'elements-test' ),
                'label_off' => esc_html__( 'Hide', 'elements-test' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $social = new Repeater();

        $social->add_control(
            'epress_team_icon',
            [
                'label' => esc_html__( 'Icon', 'elementpress' ),
                'label_block' => true,
                'type' => Controls_Manager::ICON,
                'default' => 'icon icon-facebook',
            ]
        );

        $social->add_control(
            'epress_team_label',
            [
                'label' => esc_html__( 'Label', 'elementpress' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Facebook',
            ]
        );

        $social->add_control(
            'epress_team_link',
            [
                'label' => esc_html__( 'Link', 'elementpress' ),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => 'https://facebook.com',
                ],
            ]
        );
        // start tab for content
        $social->start_controls_tabs(
            'epress_team_socialmedia_tabs'
        );

        // start normal tab
        $social->start_controls_tab(
            'epress_team_socialmedia_normal',
            [
                'label' => esc_html__( 'Normal', 'elementpress' ),
            ]
        );

        // set social icon color
        $social->add_responsive_control(
            'epress_team_socialmedia_icon_color',
            [
                'label' =>esc_html__( 'Color', 'elementpress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} > a' => 'color: {{VALUE}};',
                ],
            ]
        );

        // set social icon background color
        $social->add_responsive_control(
            'epress_team_socialmedia_icon_bg_color',
            [
                'label' =>esc_html__( 'Background Color', 'elementpress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#a1a1a1',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} > a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $social->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'epress_team_socialmedia_border',
                'label' => esc_html__( 'Border', 'elementpress' ),
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} > a',
            ]
        );

        $social->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'epress_team_socialmedia_icon_normal_text_shadow',
                'label' => esc_html__( 'Text Shadow', 'elementpress' ),
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} > a',
            ]
        );

        $social->add_group_control(
            Group_Control_Box_Shadow::get_type(), [
                'name'       => 'epress_team_socialmedai_list_box_shadow',
                'selector'   => '{{WRAPPER}} {{CURRENT_ITEM}} > a',
            ]
        );

        $social->end_controls_tab();
        // end normal tab

        //start hover tab
        $social->start_controls_tab(
            'epress_team_socialmedia_hover',
            [
                'label' => esc_html__( 'Hover', 'elementpress' ),
            ]
        );

        // set social icon color
        $social->add_responsive_control(
            'epress_team_socialmedia_icon_hover_color',
            [
                'label' =>esc_html__( 'Color', 'elementpress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} > a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        // set social icon background color
        $social->add_responsive_control(
            'epress_team_socialmedia_icon_hover_bg_color',
            [
                'label' =>esc_html__( 'Background Color', 'elementpress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#3b5998',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} > a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $social->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'epress_team_socialmedia_icon_hover_text_shadow',
                'label' => esc_html__( 'Text Shadow', 'elementpress' ),
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} > a:hover',
            ]
        );

        $social->add_group_control(
            Group_Control_Box_Shadow::get_type(), [
                'name'       => 'epress_team_socialmedai_list_box_shadow_hover',
                'selector'   => '{{WRAPPER}} {{CURRENT_ITEM}} > a:hover',
            ]
        );

        $social->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'epress_team_socialmedia_border_hover',
                'label' => esc_html__( 'Border', 'elementpress' ),
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} > a:hover',
            ]
        );

        $social->end_controls_tab();
        //end hover tab

        $social->end_controls_tabs();

        $this->add_control(
            'epress_team_social_icons',
            [
                'label' => esc_html__('Add Icon', 'elementpress'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $social->get_controls(),
                'default' => [
                    [
                        'icon' => 'icon icon-facebook',
                        'label' => 'Facebook',
                    ],
                ],
                'title_field' => '{{{ epress_team_label }}}',
                'condition' => [
                    'epress_team_socail_enable' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'epress_team_popup_details',
			[
				'label' => esc_html__( 'Pop Up And Sidebar Details', 'elementpress' ),
                'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'epress_team_chose_popup',
			[
				'label' => esc_html__( 'Show Popup', 'elementpress' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

        $this->add_control(
			'epress_team_chose_popup_style',
			[
				'label' => esc_html__( 'Popup Style', 'elementpress' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'popup',
				'options' => [
					'popup'  => esc_html__( 'Popup', 'elementpress' ),
					'sidebar' => esc_html__( 'Sidebar', 'elementpress' ),
                ],
                'condition' => [
                    'epress_team_chose_popup' => 'yes'
                ]
			]
        );

        $this->add_control(
            'epress_team_description',
            [
                'label' => esc_html__( 'About Member', 'elementpress' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'A small river named Duden flows by their place and supplies it with the necessary', 'elementpress' ),
                'placeholder' => esc_html__( 'About Member', 'elementpress' ),
                'condition' => [
                    'epress_team_chose_popup' => 'yes'
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'epress_team_phone',
            [
                'label' => esc_html__( 'Phone', 'elementpress' ),
                'type' => Controls_Manager::TEXT,
                'default' => '+1 (859) 254-6589',
                'placeholder' => esc_html__( 'Phone Number', 'elementpress' ),
                'condition' => [
                    'epress_team_chose_popup' => 'yes'
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'epress_team_email',
            [
                'label' => esc_html__( 'Email', 'elementpress' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'info@example.com',
                'placeholder' => esc_html__( 'Email Address', 'elementpress' ),
                'condition' => [
                    'epress_team_chose_popup' => 'yes'
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'epress_team_chose_sidebar_direction',
            [
                'label' => esc_html__( 'Sidebar Direction', 'elementpress' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'elementpress_sidebar_left' => [
                        'title' => esc_html__( 'Left', 'elementpress' ),
                        'icon' => 'fa fa-caret-left',
                    ],
                    'elementpress_sidebar_right' => [
                        'title' => esc_html__( 'Right', 'elementpress' ),
                        'icon' => 'fa fa-caret-right',
                    ],
                ],
                'default' => 'elementpress_sidebar_right',
                'toggle' => true,
                'condition' => [
                    'epress_team_chose_popup_style' => 'sidebar',
                    'epress_team_chose_popup' => 'yes'
                ]
            ]
        );

        // Close icon change option
        $this->add_control(
            'epress_team_close_icon_change',
            [
                'label' => esc_html__( 'Close Icon', 'elementpress' ),
                'type' => Controls_Manager::ICON,
                'default' => 'fa fa-close',
                'label_block' => true,
                'condition' => [
                    'epress_team_chose_popup' => 'yes'
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'epress_team_close_icon_alignment',
            [
                'label' => esc_html__( 'Close Icon Alignment', 'elementpress' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'elementpress' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'elementpress' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'elementpress' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'right',
                'condition' => [
                    'epress_team_chose_popup' => 'yes'
                ],
            ]
        );

		$this->end_controls_section();

        // start style section here

        // Team content section style start
        $this->start_controls_section(
            'epress_team_content_style', [
                'label' => esc_html__( 'Content', 'elementpress' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );



		$this->start_controls_tabs(
            'epress_team_background_tabs'
        );
		// start normal tab
        $this->start_controls_tab(
            'epress_team_content_normal',
            [
                'label' => esc_html__( 'Normal', 'elementpress' ),
            ]
        );

        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'epress_team_background_content_normal',
				'label' => esc_html__( 'Background', 'elementpress' ),
                'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .profile-card, {{WRAPPER}} .profile-image-card',
			]
		);
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(), [
                'name'      => 'epress_team_content_box_shadow',
                'selector'  => '{{WRAPPER}} .profile-card, {{WRAPPER}} .profile-image-card',
            ]
        );
		$this->end_controls_tab();

		$this->start_controls_tab(
            'epress_team_content_hover',
            [
                'label' => esc_html__( 'Hover', 'elementpress' ),
            ]
        );


        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'epress_team_background_content_hover',
				'label' => esc_html__( 'Background', 'elementpress' ),
                'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .profile-card:hover, {{WRAPPER}} .profile-image-card:hover, {{WRAPPER}} .profile-card::before, {{WRAPPER}} .profile-image-card::before, {{WRAPPER}} .profile-body::before',
			]
		);

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(), [
                'name'      => 'epress_team_content_box_shadow_hover_group',
                'selector'  => '{{WRAPPER}} .profile-card:hover, {{WRAPPER}} .profile-image-card:hover',
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();


		// contentmax height
        $this->add_responsive_control(
			'epress_team_content_max_weight',
			[
				'label' => esc_html__( 'Max Height', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 380,
				],
				'selectors' => [
					'{{WRAPPER}} .profile-square-v .profile-card' => 'max-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'epress_team_style' => 'hover_info'
                ]
			]
		);

        // Text aliment

        $this->add_control(
            'epress_team_content_text_align',
            [
                'label' => esc_html__( 'Alignment', 'elementpress' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'text-left' => [
                        'title' => esc_html__( 'Left', 'elementpress' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'text-center' => [
                        'title' => esc_html__( 'Center', 'elementpress' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'text-right' => [
                        'title' => esc_html__( 'Right', 'elementpress' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'text-center',
                'toggle' => true,
            ]
        );

        $this->add_responsive_control(
			'epress_team_content_padding',
			[
				'label' =>esc_html__( 'Padding', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .profile-card, {{WRAPPER}} .profile-image-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
            'epress_team_content_inner_padding',
            [
                'label' =>esc_html__( 'Content Padding', 'elementpress' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .profile-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'epress_team_content_border_color_group',
                'label' => esc_html__( 'Border', 'elementpress' ),
                'selector' => '{{WRAPPER}} .profile-card, {{WRAPPER}} .profile-image-card',
            ]
        );

        $this->add_responsive_control(
			'epress_team_content_border_radius',
			[
				'label' =>esc_html__( 'Border Radius', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px'],
				'default' => [
					'top' => '',
					'right' => '',
					'bottom' => '' ,
					'left' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .profile-card, {{WRAPPER}} .profile-image-card' =>  'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


        $this->add_control(
            'epress_team_content_overly_color_heading',
            [
                'label' => esc_html__( 'Hover Overy Color', 'elementpress' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'epress_team_style' => 'overlay_details'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'epress_team_content_overly_color',
                'label' => esc_html__( 'Background', 'elementpress' ),
                'types' => [ 'gradient'],
                'selector' => '{{WRAPPER}} .image-card-v2 .profile-image-card::before',
                'condition' => [
                       'epress_team_style' => 'overlay_details'
                ]
            ]
        );

        $this->add_control(
            'epress_team_remove_gutters',
            [
                'label' => esc_html__( 'Remove Gutter?', 'elementpress' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'elementpress' ),
                'label_off' => esc_html__( 'Yes', 'elementpress' ),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        $this->add_control(
			'epress_team_content_bg_color',
			[
				'label' => __( 'Content Background Color', 'elementpress' ),
				'type' => Controls_Manager::COLOR,
				'scheme' => [
					'type' => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .epress-wid-con .profile-square-v.square-v4 .profile-card:hover .profile-body::before' => 'background-color: {{VALUE}}',
				],
			]
		);




        $this->end_controls_section();
        // team content section style end

        // Image Styles section
        $this->start_controls_section(
            'epress_team_image_style', [
                'label' => esc_html__( 'Image', 'elementpress' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_responsive_control(
            'epress_team_image_weight',
            [
                'label' => esc_html__( 'Image Size', 'elementpress' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em' ],
                'range'  => [
                    'px' => [
                        'min'   => 10,
                        'max'   => 300,
                    ],
                ],
				'selectors' => [
					'{{WRAPPER}} .profile-header > img, {{WRAPPER}} .profile-image-card img, {{WRAPPER}} .profile-image-card, {{WRAPPER}} .profile-header ' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};'
				],
				'default' => [
					'unit' => '%'
				]
            ]
        );

        $this->add_responsive_control(
            'epress_team_image_height',
            [
                'label'         => esc_html__('Height', 'elementpress'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em'],
                'range'  => [
                    'px' => [
                        'min'   => 1,
                        'max'   => 500,
                    ],
                ],
                'condition' => [
                    'team_style!' => 'overlay',
                ],
                'selectors' => [
                    '{{WRAPPER}} .profile-card .profile-header' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'epress_team_image_height_margin_bottom',
            [
                'label' => esc_html__( 'Margin', 'elementpress' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .profile-card .profile-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );



        $this->add_responsive_control(
            'epress_team_image_width',
            [
                'label'         => esc_html__('Width', 'elementpress'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em', '%'],
                'range'  => [
                    'px' => [
                        'min'   => 1,
                        'max'   => 500,
                    ],
                ],
                'condition' => [
                    'team_style!' => 'overlay',
                ],
                'selectors' => [
                    '{{WRAPPER}} .profile-card .profile-header' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(), [
                'name'      => 'epress_team_image_shadow',
                'selector'  => '{{WRAPPER}} .profile-card .profile-header',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'epress_team_image_border',
                'label' => esc_html__( 'Border', 'elementpress' ),
                'selector' => '{{WRAPPER}} .profile-card .profile-header',
            ]
        );

        $this->add_responsive_control(
            'epress_team_image_radius',
            [
                'label' => esc_html__( 'Border radius', 'elementpress' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],

				'selectors' => [
					'{{WRAPPER}} .profile-card .profile-header' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'default' => [
					'top' => '50',
					'right' => '50',
					'left' => '50',
					'bottom' => '50',
					'unit' => '%'
				]
            ]
        );

        $this->add_responsive_control(
            'epress_team_image_margin',
            [
                'label' => esc_html__( 'Margin', 'elementpress' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'condition' => [
                    'team_style!' => 'overlay',
                ],
                'selectors' => [
                    '{{WRAPPER}} .profile-card .profile-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'epress_team_image_background',
                'label' => esc_html__( 'Background', 'elementpress' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .profile-card .profile-header',
            ]
        );

        $this->end_controls_section();


        // Name Styles
        $this->start_controls_section(
            'epress_team_name_style', [
                'label' => esc_html__( 'Name', 'elementpress' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'       => 'epress_team_name_typography',
                'selector'   => '{{WRAPPER}} .profile-body .profile-title',
            ]
        );

        $this->start_controls_tabs(
            'epress_team_name_tabs'
        );

        $this->start_controls_tab(
            'epress_team_name_normal',
            [
                'label' => esc_html__( 'Normal', 'elementpress' ),
            ]
        );

        $this->add_responsive_control(
            'epress_team_name_color',
            [
                'label'      => esc_html__( 'Color', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .profile-body .profile-title' => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->add_control(
			'epress_team_name_margin',
			[
				'label' => __( 'Margin', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .profile-card .profile-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'epress_team_name_hover',
            [
                'label' => esc_html__( 'Hover', 'elementpress' ),
            ]
        );

        $this->add_responsive_control(
            'epress_team_name_hover_color',
            [
                'label'      => esc_html__( 'Color', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .profile-body:hover .profile-title' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .profile-card:hover .profile-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
			'epress_team_name_hover_margin',
			[
				'label' => __( 'Margin', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .profile-card:hover .profile-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'epress_team_name_margin_2',
            [
                'label'         => esc_html__('Margin Bottom', 'elementpress'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em'],
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .profile-body .profile-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        // Position Styles
        $this->start_controls_section(
            'epress_team_position_style', [
                'label' => esc_html__( 'Position', 'elementpress' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'       => 'epress_team_position_typography',
                'selector'   => '{{WRAPPER}} .profile-body .profile-designation',
            ]
        );

        $this->start_controls_tabs(
            'epress_team_position_tabs'
        );

        $this->start_controls_tab(
            'epress_team_position_normal',
            [
                'label' => esc_html__( 'Normal', 'elementpress' ),
            ]
        );

        $this->add_responsive_control(
            'epress_team_position_color',
            [
                'label'      => esc_html__( 'Color', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .profile-body .profile-designation' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'epress_team_position_hover',
            [
                'label' => esc_html__( 'Hover', 'elementpress' ),
            ]
        );

        $this->add_responsive_control(
            'epress_team_position_hover_color',
            [
                'label'      => esc_html__( 'Color', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .profile-card:hover .profile-body .profile-designation,
                    {{WRAPPER}} .profile-body .profile-designation:hover' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(), [
                'name'       => 'epress_team_position_hover_shadow',
                'selector'   => '{{WRAPPER}} .profile-card:hover .profile-body .profile-designation,
                    {{WRAPPER}} .profile-body .profile-designation:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'epress_team_position_margin_bottom',
            [
                'label' => esc_html__( 'Margin Bottom', 'elementpress' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 150,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors' => [
                    '{{WRAPPER}} .profile-body .profile-designation' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();

        // Position Styles
        $this->start_controls_section(
            'epress_team_text_content_style_tab', [
                'label' => esc_html__( 'Text Content', 'elementpress' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'       => 'epress_team_text_content_typography',
                'selector'   => '{{WRAPPER}} .profile-body .profile-content',
            ]
        );

        $this->start_controls_tabs(
            'epress_team_text_content_tabs'
        );

        $this->start_controls_tab(
            'epress_team_text_content_normal',
            [
                'label' => esc_html__( 'Normal', 'elementpress' ),
            ]
        );

        $this->add_responsive_control(
            'epress_team_text_content_color',
            [
                'label'      => esc_html__( 'Color', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .profile-body .profile-content' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'epress_team_text_content_hover',
            [
                'label' => esc_html__( 'Hover', 'elementpress' ),
            ]
        );

        $this->add_responsive_control(
            'epress_team_text_content_hover_color',
            [
                'label'      => esc_html__( 'Color', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .profile-card:hover .profile-body .profile-content' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .profile-image-card:hover .profile-body .profile-content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
			'epress_team_text_content_margin_bottom',
			[
				'label' => esc_html__( 'Margin', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .profile-body .profile-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
			]
		);


        $this->end_controls_section();


        // Social Styles
        $this->start_controls_section(
            'epress_team_social_style', [
                'label' => esc_html__( 'Social  Profiles', 'elementpress' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'epress_team_socail_enable' => 'yes'
                ]
            ]
        );

        // Alignment
        $this->add_responsive_control(
            'epress_socialmedai_list_item_align',
            [
                'label' => esc_html__( 'Alignment', 'elementpress' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'elementpress' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'elementpress' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'elementpress' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
				'selectors' => [
                    '{{WRAPPER}} .epress-team-social-list > li > a' => 'text-align: {{VALUE}};',
                ],
            ]
        );

		// Display design
		 $this->add_responsive_control(
            'epress_socialmedai_list_display',
            [
                'label' => esc_html__( 'Display', 'elementpress' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'inline-block',
                'options' => [
                    'inline-block' => esc_html__( 'Inline Block', 'elementpress' ),
                    'block' => esc_html__( 'Block', 'elementpress' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .epress-team-social-list > li' => 'display: {{VALUE}};',
                ],
            ]
        );

		// text decoration
		 $this->add_responsive_control(
            'epress_socialmedai_list_decoration_box',
            [
                'label' => esc_html__( 'Decoration', 'elementpress' ),
                'type' => Controls_Manager::SELECT,
				'default' => 'none',
                'options' => [
                    'none' => esc_html__( 'None', 'elementpress' ),
                    'underline' => esc_html__( 'Underline', 'elementpress' ),
                    'overline' => esc_html__( 'Overline', 'elementpress' ),
                    'line-through' => esc_html__( 'Line Through', 'elementpress' ),

                ],
                'selectors' => ['{{WRAPPER}} .epress-team-social-list > li > a' => 'text-decoration: {{VALUE}};'],
            ]
        );


		// border radius
		 $this->add_responsive_control(
            'epress_socialmedai_list_border_radius',
            [
                'label' => esc_html__( 'Border radius', 'elementpress' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '50',
					'right' => '50',
					'bottom' => '50' ,
					'left' => '50',
					'unit' => '%',
				],
                'selectors' => [
                    '{{WRAPPER}} .epress-team-social-list > li > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		// Padding style

		 $this->add_responsive_control(
            'epress_socialmedai_list_padding',
            [
                'label'         => esc_html__('Padding', 'elementpress'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .epress-team-social-list > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		// margin style

		$this->add_responsive_control(
            'epress_socialmedai_list_margin',
            [
                'label'         => esc_html__('Margin', 'elementpress'),
                'type'          => Controls_Manager::DIMENSIONS,
                'size_units'    => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .epress-team-social-list > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'epress_socialmedai_list_typography',
				'label' => esc_html__( 'Typography', 'elementpress' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .epress-team-social-list > li > a',
			]
		);

        $this->add_control(
			'epress_socialmedai_list_style_use_height_and_width',
			[
				'label' => esc_html__( 'Use Height Width', 'elementpress' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'elementpress' ),
				'label_off' => esc_html__( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_responsive_control(
			'epress_socialmedai_list_width',
			[
				'label' => esc_html__( 'Width', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .epress-team-social-list > li > a' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'epress_socialmedai_list_style_use_height_and_width' => 'yes'
                ]
			]
		);

        $this->add_responsive_control(
			'epress_socialmedai_list_height',
			[
				'label' => esc_html__( 'Height', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .epress-team-social-list > li > a' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'epress_socialmedai_list_style_use_height_and_width' => 'yes'
                ]
			]
		);

        $this->add_responsive_control(
			'epress_socialmedai_list_line_height',
			[
				'label' => esc_html__( 'Line Height', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .epress-team-social-list > li > a' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'epress_socialmedai_list_style_use_height_and_width' => 'yes'
                ]
			]
		);

        $this->end_controls_section();


        // Overlay Styles
        $this->start_controls_section(
            'epress_team_overlay_style', [
                'label' => esc_html__( 'Overlay', 'elementpress' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'team_style' => 'overlay',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'epress_team_background_overlay',
                'label' => esc_html__( 'Background', 'elementpress' ),
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .profile-image-card:before',
            ]
        );

        $this->end_controls_section();


        // Modal Styles start here
        $this->start_controls_section(
            'epress_team_modal_style', [
                'label' => esc_html__( 'Modal Controls', 'elementpress' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'epress_team_chose_popup' => 'yes'
                ]
            ]
        );


        $this->add_control(
			'epress_team_modal_heading',
			[
				'label' => esc_html__( 'Modal', 'elementpress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'epress_team_modal_background',
                'label' => esc_html__( 'Background', 'elementpress' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .elementpress-team-popup .modal-content, {{WRAPPER}} .elementpress-team-sidebar .elementpress-modal-dialog',
            ]
        );

        $this->add_control(
            'epress_team_modal_image_heading',
            [
                'label' => esc_html__( 'Image', 'elementpress' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_responsive_control(
            'epress_team_modal_image_margin',
            [
                'label' => esc_html__( 'Margin Bottom', 'elementpress' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-sidebar .modal_image_wraper' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
			'epress_team_modal_name_heading',
			[
				'label' => esc_html__( 'Name', 'elementpress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
            'epress_team_modal_name_color',
            [
                'label'      => esc_html__( 'Color', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .xs-modal-content .xs-modal-header .person-title' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'       => 'epress_team_modal_name_typography',
                'selector'   => '{{WRAPPER}} .xs-modal-content .xs-modal-header .person-title',
            ]
        );

        $this->add_responsive_control(
            'epress_team_modal_name_margin_bottom',
            [
                'label' => esc_html__( 'Margin Bottom', 'elementpress' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 150,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors' => [
                    '{{WRAPPER}} .xs-modal-content .xs-modal-header .person-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
			'epress_team_modal_position_heading',
			[
				'label' => esc_html__( 'Position', 'elementpress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
            'epress_team_modal_position_color',
            [
                'label'      => esc_html__( 'Color', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .xs-modal-content .xs-modal-header .perosn-designation' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'       => 'epress_team_modal_position_typography',
                'selector'   => '{{WRAPPER}} .xs-modal-content .xs-modal-header .perosn-designation',
            ]
        );
        $this->add_responsive_control(
            'epress_team_modal_position_margin_bottom',
            [
                'label' => esc_html__( 'Margin Bottom', 'elementpress' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 150,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-sidebar .xs-modal-header' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );
        $this->add_control(
			'more_options',
			[
				'label' => esc_html__( 'Phone & Email', 'elementpress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);


        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name'       => 'epress_team_info_typography',
                'selector'   => '{{WRAPPER}} .border-lists>li strong,
                {{WRAPPER}} .xs-modal-content .border-lists li > a',
            ]
        );

        $this->add_responsive_control(
            'epress_team_info_color',
            [
                'label'      => esc_html__( 'Color', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .border-lists>li strong,
                    {{WRAPPER}} .xs-modal-content .border-lists li > a' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_responsive_control(
            'epress_team_info_hover_color',
            [
                'label'      => esc_html__( 'Color Hover', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .xs-modal-content .border-lists li > a:hover' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'epress_team_close_icon',
            [
                'label' => esc_html__( 'Close Icon', 'elementpress' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'epress_team_chose_popup' => 'yes'
                ]
            ]
        );

        $this->start_controls_tabs( 'epress_icon_box_icon_colors' );

        $this->start_controls_tab(
            'epress_team_icon_colors_normal',
            [
                'label' => esc_html__( 'Normal', 'elementpress' ),
            ]
        );

        $this->add_responsive_control(
            'epress_team_icon_primary_color',
            [
                'label' => esc_html__( 'Icon Color', 'elementpress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#656565',
                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'epress_team_icon_secondary_color_normal',
            [
                'label' => esc_html__( 'Icon BG Color', 'elementpress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'epress_team_border',
                'label' => esc_html__( 'Border', 'elementpress' ),
                'selector' => '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close',
            ]
        );



        $this->add_responsive_control(
            'epress_team_icon_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'elementpress' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'epress_icon_icon_box_shadow_normal_group',
                'selector' => '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close',
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'epress_team_icon_colors_hover',
            [
                'label' => esc_html__( 'Hover', 'elementpress' ),
            ]
        );

        $this->add_responsive_control(
            'epress_team_hover_primary_color',
            [
                'label' => esc_html__( 'Icon Hover Color', 'elementpress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'epress_team_hover_background_color',
            [
                'label' => esc_html__( 'Background Color', 'elementpress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'epress_team_border_icon_group',
                'label' => esc_html__( 'Border', 'elementpress' ),
                'selector' => '{{WRAPPER}} ..elementpress-team-popup .modal-content .modal-header button.close:hover',
            ]
        );

        $this->add_responsive_control(
            'epress_icon_box_icons_hover_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'elementpress' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'epress_team_shadow_group',
                'selector' => '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close:hover',
            ]
        );
        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->add_responsive_control(
            'epress_team_close_icon_size',
            [
                'label' => esc_html__( 'Size', 'elementpress' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'default' => [
                    'size' => 40,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'epress_team_close_icon_padding',
            [
                'label' => esc_html__( 'Padding', 'elementpress' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'epress_team_close_icon_enable_height_width',
            [
                'label' => esc_html__( 'Use height width', 'elementpress' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'elementpress' ),
                'label_off' => esc_html__( 'No', 'elementpress' ),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->add_responsive_control(
            'epress_team_close_icon_height',
            [
                'label' => esc_html__( 'Height', 'elementpress' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close ' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'epress_team_close_icon_enable_height_width' => 'yes',
                ],

            ]
        );

        $this->add_responsive_control(
            'epress_team_close_icon_width',
            [
                'label' => esc_html__( 'Width', 'elementpress' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                  'epress_team_close_icon_enable_height_width' => 'yes',
              ],


            ]
        );

        $this->add_responsive_control(
            'epress_team_close_icon_line_height',
            [
                'label' => esc_html__( 'Line Height', 'elementpress' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-team-popup .modal-content .modal-header button.close' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'epress_team_close_icon_enable_height_width' => 'yes',
                ],

            ]
        );

        $this->add_responsive_control(
            'epress_team_close_icon_vertical_align',
            [
                'label' => esc_html__( 'Vertical Position ', 'elementpress' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-infobox .elementpress-box-header .elementpress-info-box-icon' => ' -webkit-transform: translateY({{SIZE}}{{UNIT}}); -ms-transform: translateY({{SIZE}}{{UNIT}}); transform: translateY({{SIZE}}{{UNIT}});',
                ],
                'condition' => [
                    'epress_icon_box_icon_position!' => 'top'
                ]

            ]
        );

        $this->end_controls_section();

    }

    protected function render( ) {
        echo '<div class="epress-wid-con" >';
            $this->render_raw();
        echo '</div>';
    }

    protected function render_raw( ) {
        $settings = $this->get_settings_for_display();
        // echo "<pre>";
        // echo print_r($settings['epress_team_chose_popup']);die;

        // Image sectionn
        $image_html = '';
        if (!empty($settings['epress_team_image']['url'])) {

            $this->add_render_attribute('image', 'src', $settings['epress_team_image']['url']);
            $this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($settings['epress_team_image']));
            $this->add_render_attribute('image', 'title', Control_Media::get_image_title($settings['epress_team_image']));

            $image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'epress_team_thumbnail', 'epress_team_image');

        }

        extract($settings);

        $epress_sidebar_direction = '';
        if ($settings['epress_team_chose_popup_style']== 'sidebar') {
            $epress_sidebar_direction = $settings['epress_team_chose_sidebar_direction'];
        }

        ?>
        <!-- This box for default design-->
        <?php if ( in_array($epress_team_style, array('default', 'centered_style', 'centered_style_details', 'long_height_details', 'long_height_details_hover'))): ?>
            <?php if($epress_team_style == 'centered_style'): ?> <div class="profile-square-v"> <?php endif; ?>
            <?php if($epress_team_style == 'centered_style_details'): ?> <div class="profile-square-v square-v5 no_gutters"> <?php endif; ?>
            <?php if($epress_team_style == 'long_height_details'): ?> <div class="profile-square-v square-v6 no_gutters"> <?php endif; ?>
            <?php if($epress_team_style == 'long_height_details_hover'): ?> <div class="profile-square-v square-v6 square-v6-v2 no_gutters"> <?php endif; ?>
             <div class="profile-card <?php if(isset($epress_team_content_text_align)) { echo esc_attr($epress_team_content_text_align);} ?>">

                <div class="profile-header" <?php if ( (isset($settings['epress_team_chose_popup']) ? $epress_team_chose_popup : 'no')  == 'yes') :?> data-toggle="modal" data-target="#epress_team_modal_<?php echo esc_attr($this->get_id()); ?>" <?php endif; ?>>
                    <?php echo \ElementPress\Utils::kses($image_html); ?>
                </div><!-- .profile-header END -->

                <div class="profile-body">
                    <h2 class="profile-title">
                    <?php if ($settings['epress_team_chose_popup'] == 'yes') : ?>
                        <a  data-toggle="modal" data-target="#epress_team_modal_<?php echo esc_attr($this->get_id()); ?>"  href="#">
                        <?php echo esc_html( $epress_team_name ); ?>
                        </a>
                        <?php else: ?>
                        <?php echo esc_html( $epress_team_name ); ?>
                    <?php endif; ?>
                    </h2>
                    <p class="profile-designation"><?php echo esc_html( $epress_team_position ); ?></p>
                    <?php if($epress_team_show_short_description == 'yes' && $epress_team_short_description != ''): ?>
                    <p class="profile-content"><?php echo \ElementPress\Utils::kses($epress_team_short_description); ?></p>
                    <?php endif;?>
                </div><!-- .profile-body END -->

                <?php if(isset($epress_team_socail_enable) AND $epress_team_socail_enable == 'yes'){?>
                    <div class="profile-footer">
                        <?php if(in_array($epress_team_style, array( 'centered_style_details'))){ ?>
                            <ul class="epress-team-social-list">
                        <?php
                        }else if(in_array($epress_team_style, array( 'centered_style'))){
                        ?>
                        <ul class="epress-team-social-list ">
                        <?php
                        }else if(in_array($epress_team_style, array( 'long_height_details', 'long_height_details_hover'))){
                        ?>
                        <ul class="epress-team-social-list">
                        <?php
                        }else{
                        ?>
                        <ul class="epress-team-social-list ">
                        <?php
                        }
                        ?>
                        <?php foreach ($epress_team_social_icons as $icon): ?>
                                <li class="elementor-repeater-item-<?php echo esc_attr( $icon[ '_id' ] ); ?>"><a
                                    <?php if ( 'on' == $icon['epress_team_link']['is_external'] ): ?>
                                        target="_blank"
                                    <?php endif; ?>
                                    <?php if ( 'on' == $icon['epress_team_link']['nofollow'] ): ?>
                                        rel="nofollow"
                                    <?php endif;
                                     $getClass = explode('-',$icon['epress_team_icon']);
                                     $iconClass = end($getClass);
                                  ?> href="<?php echo esc_url( $icon['epress_team_link']['url'] ); ?>" class="<?php echo esc_attr( $iconClass ); ?>" ><i class="<?php echo esc_attr( $icon['epress_team_icon'] ); ?>"></i></a></li>
                            <?php endforeach; ?>
                        </ul>
                    </div><!-- .profile-footer END -->
                    <?php
                    }
                    ?>
                </div><!-- .profile-card END -->
                <?php if(in_array($epress_team_style, array('centered_style', 'centered_style_details', 'long_height_details', 'long_height_details_hover')) ): ?> </div> <?php endif; ?>
            <?php endif; ?>
            <!-- This box for overlay design-->

            <?php if ( in_array($epress_team_style, array('overlay', 'overlay_details', 'long_height_hover', 'overlay_circle', 'overlay_circle_hover')) ): ?>
                <?php if($epress_team_style == 'overlay_details'): ?> <div class="image-card-v2"> <?php endif; ?>
                <?php if($epress_team_style == 'long_height_hover'): ?> <div class="<?php echo esc_attr($settings['epress_team_remove_gutters'] == 'yes' ? '' : 'small-gutters'); ?> image-card-v3"> <?php endif; ?>
                <?php if($epress_team_style == 'overlay_circle'): ?> <div class="style-circle"> <?php endif; ?>
                <?php if($epress_team_style == 'overlay_circle_hover'): ?> <div class="image-card-v2 style-circle"> <?php endif; ?>
                    <div class="profile-image-card <?php if(isset($epress_team_content_text_align)) { echo esc_attr($epress_team_content_text_align);} ?>">

                        <?php if($epress_team_style == 'long_height_hover'){ ?>
                            <?php echo \ElementPress\Utils::kses($image_html); ?>
                        <?php
                            $modalClass = 'team-sidebar_'.$epress_team_style.'';
                        }else{
                            $modalClass = 'team-modal_'.$epress_team_style.'';
                        ?>
                            <?php echo \ElementPress\Utils::kses($image_html); ?>
                        <?php }?>
                        <div class="hover-area">
                            <div class="profile-body">
                                <h2 class="profile-title">
                                <?php if ( (isset($settings['epress_team_chose_popup']) ? $epress_team_chose_popup : 'no') == 'yes') : ?>
                                    <a data-toggle="modal" data-target="#epress_team_modal_<?php echo esc_attr($this->get_id()); ?>" href="#">
                                    <?php echo esc_html( $epress_team_name ); ?>
                                    </a>
                                    <?php else: ?>
                                    <?php echo esc_html( $epress_team_name ); ?>
                                <?php endif; ?>
                                </h2>
                                <p class="profile-designation"><?php echo esc_html( $epress_team_position ); ?></p>
                                <?php if($epress_team_show_short_description == 'yes' && $epress_team_short_description != ''): ?>
                                <p class="profile-content"><?php echo esc_html($epress_team_short_description); ?></p>
                                <?php endif;?>
                            </div><!-- .profile-body END -->
                            <?php if(isset($epress_team_socail_enable) && $epress_team_socail_enable == 'yes'){?>
                                <div class="profile-footer">
                                    <?php if(in_array($epress_team_style, array( 'long_height_hover'))){ ?>
                                     <ul class="epress-team-social-list ">
                                    <?php
                                    }else if(in_array($epress_team_style, array( 'overlay_details', 'overlay_circle_hover'))){
                                    ?>
                                    <ul class="epress-team-social-list  ">
                                    <?php
                                    }else{
                                    ?>
                                    <ul class="epress-team-social-list  ">
                                    <?php
                                    }
                                    ?>
                                        <?php foreach ($epress_team_social_icons as $icon): ?>
                                            <li class="elementor-repeater-item-<?php echo esc_attr( $icon[ '_id' ] ); ?>"><a
                                                <?php if ( 'on' == $icon['epress_team_link']['is_external'] ): ?>
                                                    target="_blank"
                                                <?php endif; ?>
                                                <?php if ( 'on' == $icon['epress_team_link']['nofollow'] ): ?>
                                                    rel="nofollow"
                                                <?php endif;
                                                $getClass = explode('-',$icon['epress_team_icon']);
                                                $iconClass = end($getClass);
                                              ?> href="<?php echo esc_url( $icon['epress_team_link']['url'] ); ?>" class="<?php echo esc_attr( $iconClass ); ?>" ><i class="<?php echo esc_attr( $icon['epress_team_icon'] ); ?>"></i></a></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div><!-- .profile-footer END -->
                            <?php
                            }
                            ?>
                        </div>
                    </div><!-- .profile-image-card END -->
                    <?php if(in_array($epress_team_style, array('overlay_details', 'long_height_hover' , 'overlay_circle', 'overlay_circle_hover')) ): ?> </div> <?php endif; ?>

                <?php
                endif;
                if ( 'hover_info' == $epress_team_style ):
                ?>
                <!-- This box for overlay design-->
                <div class="profile-square-v square-v4">
                    <div class="profile-card <?php if(isset($epress_team_content_text_align)) { echo esc_attr($epress_team_content_text_align);} ?>">
                        <div class="profile-header" <?php if ($settings['epress_team_chose_popup'] == 'yes') :?> data-toggle="modal" data-target="#epress_team_modal_<?php echo esc_attr($this->get_id()); ?>" <?php endif; ?>>
                            <?php echo \ElementPress\Utils::kses($image_html); ?>
                        </div><!-- .profile-header END -->
                        <div class="profile-body">
                            <h2 class="profile-title">
                            <?php if ( (isset($settings['epress_team_chose_popup']) ? $epress_team_chose_popup : 'no') == 'yes') : ?>
                                <a data-toggle="modal" data-target="#epress_team_modal_<?php echo esc_attr($this->get_id()); ?>" href="#">
                                <?php echo esc_html( $epress_team_name ); ?>
                                </a>
                            <?php else: ?>
                             <?php echo esc_html( $epress_team_name ); ?>
                            <?php endif; ?>
                            </h2>
                            <p class="profile-designation"><?php echo esc_html( $epress_team_position ); ?></p>
                            <?php if($epress_team_show_short_description == 'yes' && $epress_team_short_description != ''): ?>
                            <p class="profile-content"><?php echo esc_html($epress_team_short_description); ?></p>
                            <?php endif;?>
                            <?php if(isset($epress_team_socail_enable) AND $epress_team_socail_enable == 'yes'){?>
                                <?php if(in_array($epress_team_style, array( 'hover_info'))){ ?>
                                <ul class="epress-team-social-list">
                                <?php
                                }else if(in_array($epress_team_style, array( 'hover_info_two'))){
                                ?>
                                <ul class="epress-team-social-list ">
                                <?php
                                }else{
                                ?>
                                <ul class="epress-team-social-list ">
                                <?php
                                }
                                ?>

                                    <?php foreach ($epress_team_social_icons as $icon): ?>
                                        <li class="elementor-repeater-item-<?php echo esc_attr( $icon[ '_id' ] ); ?>"><a
                                            <?php if ( 'on' == $icon['epress_team_link']['is_external'] ): ?>
                                                target="_blank"
                                            <?php endif; ?>
                                            <?php if ( 'on' == $icon['epress_team_link']['nofollow'] ): ?>
                                                rel="nofollow"
                                            <?php endif;
                                             $getClass = explode('-',$icon['epress_team_icon']);
                                             $iconClass = end($getClass);
                                            ?> href="<?php echo esc_url( $icon['epress_team_link']['url'] ); ?>" class="<?php echo esc_attr( $iconClass ); ?>" ><i class="<?php echo esc_attr( $icon['epress_team_icon'] ); ?>"></i></a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php
                            }
                            ?>
                        </div><!-- .profile-body END -->
                    </div><!-- .profile-card END -->
                </div>
            <?php endif; ?>

        <!-- start team modal Style -->
        <?php if ((isset($settings['epress_team_chose_popup']) ? $epress_team_chose_popup : 'no') == 'yes') : ?>
        <?php if ($settings['epress_team_chose_popup_style'] == 'popup') : ?>
        <div class="modal fade elementpress-team-popup" id="epress_team_modal_<?php echo esc_attr($this->get_id()); ?>" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close <?php echo esc_attr($epress_team_close_icon_alignment); ?>" data-dismiss="modal" aria-label="Close">
                            <?php if($epress_team_close_icon_change != '') :  ?>

                                <span aria-hidden="true" class="<?php echo esc_attr($epress_team_close_icon_change); ?>"></span>
                            <?php else:  ?>
                                <span aria-hidden="true">&times;</span>
                            <?php endif; ?>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="modal_image_wraper">
                            <div class="modal-img">
                            <?php echo \ElementPress\Utils::kses($image_html); ?>
                            </div>
                        </div>
                        <div class="modal_content_wraper">
                            <div class="xs-modal-content">
                                <div class="xs-modal-header">
                                    <h2 class="person-title"><?php echo esc_html( $epress_team_name ); ?></h2>
                                    <span class="perosn-designation"><?php echo esc_html( $epress_team_position ); ?></span>
                                </div><!-- .xs-modal-header END -->
								<div class="xs-modal-body">
                                    <?php echo \ElementPress\Utils::kses($epress_team_description); ?>
                                </div><!-- .xs-modal-body END -->
                                <div class="xs-modal-footer">
                                    <?php if ( $epress_team_phone || $epress_team_email ): ?>
                                        <ul class="border-lists">
                                            <?php if ( $epress_team_phone ): ?>
                                                <li><strong><?php esc_html_e( 'Phone', 'elementpress' ); ?>:</strong><a href="tel:<?php echo esc_attr( $epress_team_phone ); ?>"><?php echo esc_html( $epress_team_phone ); ?></a></li>
                                            <?php endif; ?>

                                            <?php if ( $epress_team_email ): ?>
                                                <li><strong><?php esc_html_e( 'Email', 'elementpress' ); ?>:</strong><a href="mailto:<?php echo esc_attr( $epress_team_email ); ?>"><?php echo esc_html( $epress_team_email ); ?></a></li>
                                            <?php endif; ?>
                                        </ul>
                                    <?php endif; ?>
                                    <?php if(isset($epress_team_socail_enable) AND $epress_team_socail_enable == 'yes'){?>
                                    <ul class="epress-team-social-list ">
                                        <?php foreach ($epress_team_social_icons as $icon): ?>
                                            <li class="elementor-repeater-item-<?php echo esc_attr( $icon[ '_id' ] ); ?>"><a
                                                <?php if ( 'on' == $icon['epress_team_link']['is_external'] ): ?>
                                                    target="_blank"
                                                <?php endif; ?>
                                                <?php if ( 'on' == $icon['epress_team_link']['nofollow'] ): ?>
                                                    rel="nofollow"
                                                <?php endif; ?>

                                                href="<?php echo esc_url( $icon['epress_team_link']['url'] ); ?>" class="social-icons elementor-social-icon-facebook"><i class="<?php echo esc_attr( $icon['epress_team_icon'] ); ?>"></i></a></li>
                                        <?php endforeach; ?>
                                    </ul>
                                    <?php
                                    }
                                    ?>
                                </div><!-- .xs-modal-footer END -->
                            </div><!-- .xs-modal-content END -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php else : ?>
        <div class="modal fade elementpress-team-sidebar <?php echo esc_attr($epress_sidebar_direction); ?>" id="epress_team_modal_<?php echo esc_attr($this->get_id()); ?>" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog elementpress-modal-dialog" role="document">
                <div class="elementpress-modal-content">
                    <div class="elementpress-modal-header">
                        <button type="button" class="close <?php echo esc_attr($epress_team_close_icon_alignment); ?>" data-dismiss="modal" aria-label="Close">
                            <?php if($epress_team_close_icon_change != '') :  ?>

                                <span aria-hidden="true" class="<?php echo esc_attr($epress_team_close_icon_change); ?>"></span>
                            <?php else:  ?>
                                <span aria-hidden="true">&times;</span>
                            <?php endif; ?>
                        </button>
                    </div>
                    <div class="elementpressmodal-body">
                        <div class="modal_image_wraper">
                            <div class="modal-img">
                            <?php echo \ElementPress\Utils::kses($image_html); ?>
                            </div>
                        </div>
                        <div class="modal_content_wraper">
                            <div class="xs-modal-content">
                                <div class="xs-modal-header">
                                    <h2 class="person-title"><?php echo esc_html( $epress_team_name ); ?></h2>
                                    <span class="perosn-designation"><?php echo esc_html( $epress_team_position ); ?></span>
                                </div><!-- .xs-modal-header END -->
                                <div class="xs-modal-body">
                                    <?php echo \ElementPress\Utils::kses($epress_team_description); ?>
                                </div><!-- .xs-modal-body END -->
                                <div class="xs-modal-footer">
                                    <?php if ( $epress_team_phone || $epress_team_email ): ?>
                                        <ul class="border-lists">
                                            <?php if ( $epress_team_phone ): ?>
                                                <li><strong><?php esc_html_e( 'Phone', 'elementpress' ); ?>:</strong><a href="tel:<?php echo esc_attr( $epress_team_phone ); ?>"><?php echo esc_html( $epress_team_phone ); ?></a></li>
                                            <?php endif; ?>

                                            <?php if ( $epress_team_email ): ?>
                                                <li><strong><?php esc_html_e( 'Email', 'elementpress' ); ?>:</strong><a href="mailto:<?php echo esc_attr( $epress_team_email ); ?>"><?php echo esc_html( $epress_team_email ); ?></a></li>
                                            <?php endif; ?>
                                        </ul>
                                    <?php endif; ?>
                                    <?php if(isset($epress_team_socail_enable) AND $epress_team_socail_enable == 'yes'){?>
                                    <ul class="epress-team-social-list ">
                                        <?php foreach ($epress_team_social_icons as $icon): ?>
                                            <li class="elementor-repeater-item-<?php echo esc_attr( $icon[ '_id' ] ); ?>"><a
                                                <?php if ( 'on' == $icon['epress_team_link']['is_external'] ): ?>
                                                    target="_blank"
                                                <?php endif; ?>
                                                <?php if ( 'on' == $icon['epress_team_link']['nofollow'] ): ?>
                                                    rel="nofollow"
                                                <?php endif; ?>

                                                href="<?php echo esc_url( $icon['epress_team_link']['url'] ); ?>" class="social-icons elementor-social-icon-facebook"><i class="<?php echo esc_attr( $icon['epress_team_icon'] ); ?>"></i></a></li>
                                        <?php endforeach; ?>
                                    </ul>
                                    <?php
                                    }
                                    ?>
                                </div><!-- .xs-modal-footer END -->
                            </div><!-- .xs-modal-content END -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php endif; ?>

        <?php
    }

    protected function content_template() { }
}
