<?php 


namespace ElementPress\Libs\Framework;


use ElementPress\Libs\Framework\Classes\Utils;





defined( 'ABSPATH' ) || exit;





class Attr{





    /**


	 * The class instance.


	 *


	 * @since 1.0.0


	 * @access public


	 * @static


	 *


	 * @var Attr


	 */


    public static $instance = null;


    public $utils;





    public static function get_dir(){


        return \ElementPress::lib_dir() . 'framework/';


    }





    public static function get_url(){


        return \ElementPress::lib_url() . 'framework/';


    }





    public static function key(){


        return 'elementpress';


    }





    public function __construct() {


        $this->utils = Classes\Utils::instance();


        new Classes\Ajax;





        





        // register admin menus


        add_action('admin_menu', [$this, 'register_settings_menus']);


        add_action('admin_menu', [$this, 'register_support_menu'], 999);





        // register js/ css


        add_action( 'admin_enqueue_scripts', [$this, 'enqueue_scripts'] );


        


    }





    public function include_files(){





    }





    public function enqueue_scripts(){


        wp_register_style( 'elementpress-admin-global', \ElementPress::lib_url() . 'framework/assets/css/admin-global.css', \ElementPress::VERSION );


        wp_enqueue_style( 'elementpress-admin-global' );


    }





    public function register_settings_menus(){


        // add_menu_page( string $page_title, string $menu_title, string $capability, string $menu_slug, callable $function = '', string $icon_url = '', int $position = null )





        // dashboard, main menu


        add_menu_page(


            esc_html__( 'Settings', 'elementpress' ),


            esc_html__( 'Elementor Opt', 'elementpress' ),


            'manage_options',


            self::key(),


            [$this, 'register_settings_contents__settings'],


            self::get_url() . 'assets/images/favicon.png',


            6


        );





        // add_submenu_page( $parent_slug, $page_title, $menu_title, $capability, $menu_slug, $function = '' )


        //add_submenu_page( self::key(), 'ElementorOpt Help', 'Help', 'manage_options', self::key().'-help', [$this, 'register_settings_contents__help'], 11);


    }








    public function register_support_menu(){


        //add_submenu_page( self::key(), esc_html__( 'Get Support', 'elementpress' ), esc_html__( 'Get Support', 'elementpress' ), 'manage_options', self::key().'-support', [$this, 'register_settings_contents__support'], 11);


       // add_submenu_page( self::key(), esc_html__( 'License', 'elementpress' ), esc_html__( 'License', 'elementpress' ), 'manage_options', self::key().'-license', [$this, 'register_settings_contents__license'], 11);


    }








    public function register_settings_contents__settings(){


       // include self::get_dir() . 'pages/settings-init.php';


    }





    public function register_settings_contents__license(){


        include self::get_dir() . 'pages/license.php';


    }





    public function register_settings_contents__support(){


        echo esc_html__('Please wait..', 'elementpress');


        echo '


            


        ';


    }








    /**


     * Instance.


     * 


     * Ensures only one instance of the class is loaded or can be loaded.


     *


     * @since 1.0.0


     * @access public


     * @static


     *


     * @return Build_Widgets An instance of the class.


     */


    public static function instance() {


        if ( is_null( self::$instance ) ) {





            // Fire the class instance


            self::$instance = new self();


        }





        return self::$instance;


    }


}