<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Element;

use EPRESS\Module\ModuleOptionAbstract;

Class Element_Blocklink_Option extends ModuleOptionAbstract
{
    public function compatible_column()
    {
        return array( 4, 8 , 12 );
    }

    public function get_module_name()
    {
        return esc_html__('ElementPress - Block Link', 'elementpress');
    }

	public function get_category()
	{
		return esc_html__('EPRESS - Element', 'elementpress');
	}

    public function set_options()
    {
        $this->set_playlist_option();
        $this->set_style_option();
    }

    public function set_playlist_option()
    {
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'first_title',
            'heading'       => esc_html__('Title', 'elementpress'),
            'description'   => esc_html__('Insert a text for block link title.', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'second_title',
            'heading'       => esc_html__('Second Title', 'elementpress'),
            'description'   => esc_html__('Sub title or short description.', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'title_url',
            'heading'       => esc_html__('Title URL', 'elementpress'),
            'description'   => esc_html__('Url of block link title.', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'checkbox',
            'param_name'    => 'newtab',
            'heading'       => esc_html__('Open New Tab', 'elementpress'),
            'description'   => esc_html__('Check this option to open link on new tab.', 'elementpress'),
        );
        $this->options[] = array(
            'type'          => 'attach_image',
            'param_name'    => 'image',
            'heading'       => esc_html__('Background Image', 'elementpress'),
            'description'   => esc_html__('Choose an image for block background.', 'elementpress'),
        );

        $this->options[] = array(
            'type'          => 'checkbox',
            'param_name'    => 'use_video_bg',
            'heading'       => esc_html__('Use Video Background', 'elementpress'),
            'description'   => esc_html__('If checked, video will be used as background.', 'elementpress'),
        );

        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'video_url',
            'heading'       => esc_html__('YouTube Link', 'elementpress'),
            'description'   => esc_html__('Add YouTube video link to used as video background.', 'elementpress'),
            'dependency'    => array('element' => 'use_video_bg', 'value' => 'true'),
        );
    }

	public function set_typography_option( $instance ) {

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'title_typography',
				'label'       => esc_html__( 'Title Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for title', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_block_content h3',
			]
		);

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'meta_typography',
				'label'       => esc_html__( 'Second Title Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for second title', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_block_content span',
			]
		);
	}
}
