<?php

namespace Elementor;

use \Elementor\Controls_Manager;



if ( ! defined( 'ABSPATH' ) ) {

	exit; // Exit if accessed directly.

}



use Elementor\Core\Schemes;



class ElementPress_Widget_Accordion extends Widget_Base {



	public $base;



	public function __construct($data = [], $args = null) {

		parent::__construct($data, $args);

		wp_register_script( 'epress-accordin-js',  \ElementPress::widgets_url() .'/accordin/assets/js/epress-accordin.js', array( 'jquery' ), \ElementPress::version, true);

		wp_register_style( 'epress-accordin-css',  \ElementPress::widgets_url() . '/accordin/assets/css/epress-accordin.css', false, \ElementPress::version );

		add_action('elementor/editor/after_enqueue_scripts', function() {

			wp_enqueue_script('epress-accordin-admin-js',  \ElementPress::widgets_url() .'/accordin/assets/js/epress-accordin.js', array( 'jquery' ), \ElementPress::version, true );

		});



	}

	public function get_script_depends() {

		return [

			'epress-accordin-js',

		];

	}

	public function get_style_depends() {



		return [ 'epress-accordin-css' ];

	}



	public function get_name() {

		return 'epress-accordion';

	}





	public function get_title() {

		return __( 'Epress Accordion', 'elementor' );

	}



	

	public function get_icon() {

		return 'eicon-accordion';

    }

    public function get_categories() {

		//get categories from postcontent-handler file

        return [ 'additional-addons' ];

	}





	public function get_keywords() {

		return [ 'accordion', 'tabs', 'toggle' ];

	}



	/**

	 * Register accordion widget controls.

	 *

	 * Adds different input fields to allow the user to change and customize the widget settings.

	 *

	 * @since 1.0.0

	 * @access protected

	 */

	protected function register_controls() {

		$this->start_controls_section(

			'section_title',

			[

				'label' => __( 'Accordion', 'elementor' ),

			]

		);



		$repeater = new Repeater();



		$repeater->add_control(

			'tab_title',

			[

				'label' => __( 'Title & Description', 'elementor' ),

				'type' => Controls_Manager::TEXT,

				'default' => __( 'Accordion Title', 'elementor' ),

				'dynamic' => [

					'active' => true,

				],

				'label_block' => true,

			]

		);



		$repeater->add_control(

			'tab_content',

			[

				'label' => __( 'Content', 'elementor' ),

				'type' => Controls_Manager::WYSIWYG,

				'default' => __( 'Accordion Content', 'elementor' ),

				'show_label' => false,

			]

		);



		$this->add_control(

			'tabs',

			[

				'label' => __( 'Accordion Items', 'elementor' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => $repeater->get_controls(),

				'default' => [

					[

						'tab_title' => __( 'Accordion #1', 'elementor' ),

						'tab_content' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'elementor' ),

					],

					[

						'tab_title' => __( 'Accordion #2', 'elementor' ),

						'tab_content' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'elementor' ),

					],

				],

				'title_field' => '{{{ tab_title }}}',

			]

		);



		$this->add_control(

			'view',

			[

				'label' => __( 'View', 'elementor' ),

				'type' => Controls_Manager::HIDDEN,

				'default' => 'traditional',

			]

		);



		$this->add_control(

			'selected_icon',

			[

				'label' => __( 'Icon', 'elementor' ),

				'type' => Controls_Manager::ICONS,

				'separator' => 'before',

				'fa4compatibility' => 'icon',

				'default' => [

					'value' => 'fas fa-plus',

					'library' => 'fa-solid',

				],

				'recommended' => [

					'fa-solid' => [

						'chevron-down',

						'angle-down',

						'angle-double-down',

						'caret-down',

						'caret-square-down',

					],

					'fa-regular' => [

						'caret-square-down',

					],

				],

				'skin' => 'inline',

				'label_block' => false,

			]

		);



		$this->add_control(

			'selected_active_icon',

			[

				'label' => __( 'Active Icon', 'elementor' ),

				'type' => Controls_Manager::ICONS,

				'fa4compatibility' => 'icon_active',

				'default' => [

					'value' => 'fas fa-minus',

					'library' => 'fa-solid',

				],

				'recommended' => [

					'fa-solid' => [

						'chevron-up',

						'angle-up',

						'angle-double-up',

						'caret-up',

						'caret-square-up',

					],

					'fa-regular' => [

						'caret-square-up',

					],

				],

				'skin' => 'inline',

				'label_block' => false,

				'condition' => [

					'selected_icon[value]!' => '',

				],

			]

		);



		$this->add_control(

			'title_html_tag',

			[

				'label' => __( 'Title HTML Tag', 'elementor' ),

				'type' => Controls_Manager::SELECT,

				'options' => [

					'h1' => 'H1',

					'h2' => 'H2',

					'h3' => 'H3',

					'h4' => 'H4',

					'h5' => 'H5',

					'h6' => 'H6',

					'div' => 'div',

				],

				'default' => 'div',

				'separator' => 'before',

			]

		);



		$this->end_controls_section();



		$this->start_controls_section(

			'section_toggle_style_title',

			[

				'label' => __( 'Title Style', 'elementor' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);



		$this->add_control(

			'title_background',

			[

				'label' => __( 'Background', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .epress-accordion .epress-tab-title' => 'background-color: {{VALUE}};',

				],

			]

		);



		$this->add_control(

			'title_color',

			[

				'label' => __( 'Color', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .epress-accordion-icon, {{WRAPPER}} a' => 'color: {{VALUE}};',

				],

				'scheme' => [

					'type' => Schemes\Color::get_type(),

					'value' => Schemes\Color::COLOR_1,

				],

			]

		);



		$this->add_control(

			'tab_active_color',

			[

				'label' => __( 'Active Color', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .epress-active .epress-accordion-icon, {{WRAPPER}} .epress-active a' => 'color: {{VALUE}};',

				],

				'scheme' => [

					'type' => Schemes\Color::get_type(),

					'value' => Schemes\Color::COLOR_4,

				],

			]

		);



		$this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'title_typography',

				'selector' => '{{WRAPPER}} .epress-accordion .epress-tab-title',

				'scheme' => Schemes\Typography::TYPOGRAPHY_1,

			]

		);



		$this->add_responsive_control(

			'title_padding',

			[

				'label' => __( 'Padding', 'elementor' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', 'em', '%' ],

				'selectors' => [

					'{{WRAPPER}} .epress-accordion .epress-tab-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

        );

        

        $this->add_responsive_control(

			'title_margin',

			[

				'label' => __( 'Margin', 'elementor' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', 'em', '%' ],

				'selectors' => [

					'{{WRAPPER}} .epress-accordion .epress-tab-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',

				],

			]

		);





		$this->add_group_control(

			Group_Control_Border::get_type(),

			[

				'name' => 'title_border',

				'label' => __( 'Border', 'elementpress' ),

				'selector' => '{{WRAPPER}} .epress-accordion .epress-tab-title',

			]

		);



		$this->add_responsive_control(

			'title_border_radius',

			[

				'label' =>esc_html__( 'Border Radius', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px'],

				'default' => [

					'top' => '',

					'right' => '',

					'bottom' => '' ,

					'left' => '',

				],

				'selectors' => [

					'{{WRAPPER}} .epress-accordion .epress-tab-title' =>  'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

		);

	



		$this->end_controls_section();



		$this->start_controls_section(

			'section_toggle_style_icon',

			[

				'label' => __( 'Icon Style', 'elementor' ),

				'tab' => Controls_Manager::TAB_STYLE,

				'condition' => [

					'selected_icon[value]!' => '',

				],

			]

		);



		$this->add_control(

			'icon_align',

			[

				'label' => __( 'Alignment', 'elementor' ),

				'type' => Controls_Manager::CHOOSE,

				'options' => [

					'left' => [

						'title' => __( 'Start', 'elementor' ),

						'icon' => 'eicon-h-align-left',

					],

					'right' => [

						'title' => __( 'End', 'elementor' ),

						'icon' => 'eicon-h-align-right',

					],

				],

				'default' => is_rtl() ? 'right' : 'left',

				'toggle' => false,

			]

		);



		$this->add_control(

			'icon_color',

			[

				'label' => __( 'Color', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .epress-accordion .epress-tab-title .epress-accordion-icon i:before' => 'color: {{VALUE}};',

					'{{WRAPPER}} .epress-accordion .epress-tab-title .epress-accordion-icon svg' => 'fill: {{VALUE}};',

				],

			]

		);



		$this->add_control(

			'icon_active_color',

			[

				'label' => __( 'Active Color', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .epress-accordion .epress-tab-title.epress-active .epress-accordion-icon i:before' => 'color: {{VALUE}};',

					'{{WRAPPER}} .epress-accordion .epress-tab-title.epress-active .epress-accordion-icon svg' => 'fill: {{VALUE}};',

				],

			]

		);



		$this->add_responsive_control(

			'icon_space',

			[

				'label' => __( 'Spacing', 'elementor' ),

				'type' => Controls_Manager::SLIDER,

				'range' => [

					'px' => [

						'min' => 0,

						'max' => 100,

					],

				],

				'selectors' => [

					'{{WRAPPER}} .epress-accordion .epress-accordion-icon.epress-accordion-icon-left' => 'margin-right: {{SIZE}}{{UNIT}};',

					'{{WRAPPER}} .epress-accordion .epress-accordion-icon.epress-accordion-icon-right' => 'margin-left: {{SIZE}}{{UNIT}};',

				],

			]

		);





		$this->end_controls_section();



		$this->start_controls_section(

			'section_toggle_style_content',

			[

				'label' => __( 'Content Style', 'elementor' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);



		$this->add_control(

			'content_background_color',

			[

				'label' => __( 'Background', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .epress-accordion .epress-tab-content' => 'background-color: {{VALUE}};',

				],

			]

		);



		$this->add_control(

			'content_color',

			[

				'label' => __( 'Color', 'elementor' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .epress-accordion .epress-tab-content' => 'color: {{VALUE}};',

				],

				'scheme' => [

					'type' => Schemes\Color::get_type(),

					'value' => Schemes\Color::COLOR_3,

				],

			]

		);



		$this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'content_typography',

				'selector' => '{{WRAPPER}} .epress-accordion .epress-tab-content',

				'scheme' => Schemes\Typography::TYPOGRAPHY_3,

			]

		);



		$this->add_responsive_control(

			'content_padding',

			[

				'label' => __( 'Padding', 'elementor' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', 'em', '%' ],

				'selectors' => [

					'{{WRAPPER}} .epress-accordion .epress-tab-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

        );

        $this->add_responsive_control(

			'content_margin',

			[

				'label' => __( 'Margin', 'elementor' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', 'em', '%' ],

				'selectors' => [

					'{{WRAPPER}} .epress-accordion .epress-tab-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

		);



		$this->add_group_control(

			Group_Control_Border::get_type(),

			[

				'name' => 'content_border',

				'label' => __( 'Border', 'elementpress' ),

				'selector' => '{{WRAPPER}} .epress-accordion .epress-tab-content',

			]

		);



		$this->add_responsive_control(

			'content_border_radius',

			[

				'label' =>esc_html__( 'Border Radius', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px'],

				'default' => [

					'top' => '',

					'right' => '',

					'bottom' => '' ,

					'left' => '',

				],

				'selectors' => [

					'{{WRAPPER}} .epress-accordion .epress-tab-content' =>  'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

		);



		$this->end_controls_section();

	}



	/**

	 * Render accordion widget output on the frontend.

	 *

	 * Written in PHP and used to generate the final HTML.

	 *

	 * @since 1.0.0

	 * @access protected

	 */

	protected function render() {

		$settings = $this->get_settings_for_display();

		$migrated = isset( $settings['__fa4_migrated']['selected_icon'] );



		if ( ! isset( $settings['icon'] ) && ! Icons_Manager::is_migration_allowed() ) {

			// @todo: remove when deprecated

			// added as bc in 2.6

			// add old default

			$settings['icon'] = 'fa fa-plus';

			$settings['icon_active'] = 'fa fa-minus';

			$settings['icon_align'] = $this->get_settings( 'icon_align' );

		}



		$is_new = empty( $settings['icon'] ) && Icons_Manager::is_migration_allowed();

		$has_icon = ( ! $is_new || ! empty( $settings['selected_icon']['value'] ) );

		$id_int = substr( $this->get_id_int(), 0, 3 );

		?>

		<div class="epress-accordion" role="tablist">

			<?php

			foreach ( $settings['tabs'] as $index => $item ) :

				$tab_count = $index + 1;



				$tab_title_setting_key = $this->get_repeater_setting_key( 'tab_title', 'tabs', $index );



				$tab_content_setting_key = $this->get_repeater_setting_key( 'tab_content', 'tabs', $index );



				$this->add_render_attribute( $tab_title_setting_key, [

					'id' => 'epress-tab-title-' . $id_int . $tab_count,

					'class' => [ 'epress-tab-title' ],

					'data-tab' => $tab_count,

					'role' => 'tab',

					'aria-controls' => 'epress-tab-content-' . $id_int . $tab_count,

				] );



				$this->add_render_attribute( $tab_content_setting_key, [

					'id' => 'epress-tab-content-' . $id_int . $tab_count,

					'class' => [ 'epress-tab-content', 'epress-clearfix' ],

					'data-tab' => $tab_count,

					'role' => 'tabpanel',

					'aria-labelledby' => 'epress-tab-title-' . $id_int . $tab_count,

				] );



				$this->add_inline_editing_attributes( $tab_content_setting_key, 'advanced' );

				?>

				<div class="epress-accordion-item">

					<<?php echo $settings['title_html_tag']; ?> <?php echo $this->get_render_attribute_string( $tab_title_setting_key ); ?>>

						<?php if ( $has_icon ) : ?>

							<span class="epress-accordion-icon epress-accordion-icon-<?php echo esc_attr( $settings['icon_align'] ); ?>" aria-hidden="true">

							<?php

							if ( $is_new || $migrated ) { ?>

								<span class="epress-accordion-icon-closed"><?php Icons_Manager::render_icon( $settings['selected_icon'] ); ?></span>

								<span class="epress-accordion-icon-opened"><?php Icons_Manager::render_icon( $settings['selected_active_icon'] ); ?></span>

							<?php } else { ?>

								<span class="epress-accordion-icon-closed <?php echo esc_attr( $settings['icon'] ); ?>"></span>

								<span class="epress-accordion-icon-opened <?php echo esc_attr( $settings['icon_active'] ); ?>"></span>

							<?php } ?>

							</span>

						<?php endif; ?>

						<a href="#"><?php echo $item['tab_title']; ?></a>

					</<?php echo $settings['title_html_tag']; ?>>

					<div <?php echo $this->get_render_attribute_string( $tab_content_setting_key ); ?>><?php echo $this->parse_text_editor( $item['tab_content'] ); ?></div>

				</div>

			<?php endforeach; ?>

		</div>

		<?php

	}



	/**

	 * Render accordion widget output in the editor.

	 *

	 * Written as a Backbone JavaScript template and used to generate the live preview.

	 *

	 * @since 2.9.0

	 * @access protected

	 */

	protected function content_template() {

		?>

		<div class="epress-accordion" role="tablist">

			<#

			if ( settings.tabs ) {

				var tabindex = view.getIDInt().toString().substr( 0, 3 ),

					iconHTML = elementor.helpers.renderIcon( view, settings.selected_icon, {}, 'i' , 'object' ),

					iconActiveHTML = elementor.helpers.renderIcon( view, settings.selected_active_icon, {}, 'i' , 'object' ),

					migrated = elementor.helpers.isIconMigrated( settings, 'selected_icon' );



				_.each( settings.tabs, function( item, index ) {

					var tabCount = index + 1,

						tabTitleKey = view.getRepeaterSettingKey( 'tab_title', 'tabs', index ),

						tabContentKey = view.getRepeaterSettingKey( 'tab_content', 'tabs', index );



					view.addRenderAttribute( tabTitleKey, {

						'id': 'epress-tab-title-' + tabindex + tabCount,

						'class': [ 'epress-tab-title' ],

						'tabindex': tabindex + tabCount,

						'data-tab': tabCount,

						'role': 'tab',

						'aria-controls': 'epress-tab-content-' + tabindex + tabCount

					} );



					view.addRenderAttribute( tabContentKey, {

						'id': 'epress-tab-content-' + tabindex + tabCount,

						'class': [ 'epress-tab-content', 'epress-clearfix' ],

						'data-tab': tabCount,

						'role': 'tabpanel',

						'aria-labelledby': 'epress-tab-title-' + tabindex + tabCount

					} );



					view.addInlineEditingAttributes( tabContentKey, 'advanced' );

					#>

					<div class="epress-accordion-item">

						<{{{ settings.title_html_tag }}} {{{ view.getRenderAttributeString( tabTitleKey ) }}}>

							<# if ( settings.icon || settings.selected_icon ) { #>

							<span class="epress-accordion-icon epress-accordion-icon-{{ settings.icon_align }}" aria-hidden="true">

								<# if ( iconHTML && iconHTML.rendered && ( ! settings.icon || migrated ) ) { #>

									<span class="epress-accordion-icon-closed">{{{ iconHTML.value }}}</span>

									<span class="epress-accordion-icon-opened">{{{ iconActiveHTML.value }}}</span>

								<# } else { #>

									<span class="epress-accordion-icon-closed {{ settings.icon }}"></span>

									<span class="epress-accordion-icon-opened {{ settings.icon_active }}"></span>

								<# } #>

							</span>

							<# } #>

							<a href="">{{{ item.tab_title }}}</a>

						</{{{ settings.title_html_tag }}}>

						<div {{{ view.getRenderAttributeString( tabContentKey ) }}}>{{{ item.tab_content }}}</div>

					</div>

					<#

				} );

			} #>

		</div>

		<?php

	}

}

